package net.zomis.mfe.plugin;

import net.zomis.minesweeper.ais.utils.ChickenAnalyze;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;

public class AI_ZomisPlugin extends MinesweeperPlugin implements EventListener {
	
	@Command(command = "chicken", help = "Quickly analyze chicken-play", requiredPermission = PlayerCommandEvent.PERMISSION_TRUSTED_USER)
	public void zomisAI(PlayerCommandEvent event) {
		if (event.getMap() == null) return;
		
//		AI_Zomis ai = new AI_Nightmare(event.getMap().getCurrentPlayer());
		ChickenAnalyze chicken = new ChickenAnalyze(event.getMap(), AnalyzeFactory.analyze(event.getMap(), true));
		chicken.analyze();
		event.getPlayer().sendChat(chicken.toString());
	}

	@Override
	public void onEnable() {
		registerListener(this);
	}

	@Override
	public void onDisable() {
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer user) {
		return false;
	}

}
