package net.tejpbit.ais;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Random;

import net.zomis.UtilZomisList;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

// @AI(rating = 1500)
public class TejpbitAI_Hard extends MinesweeperAI {

	public TejpbitAI_Hard() {
		super("#TejpbitAI_Hard");
	}

	@Override
	public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
		return MineprobHelper.isDraw(pp.getMap());
	}
	
	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		AnalyzeResult<MinesweeperField> gameAnalyze = AnalyzeFactory.analyze(pp.getMap(), false).getAnalyze();
		
		if (pp.canUseWeapon(MinesweeperMove.STANDARD_BOMB)) {
			MinesweeperField bombField = eredags(pp, gameAnalyze);
			if (bombField != null)
				return pp.createMove(MinesweeperMove.STANDARD_BOMB, bombField);
		}
			
		List<FieldGroup<MinesweeperField>> groups = gameAnalyze.getGroups();
		List<MinesweeperField> highProbabilityFields = new ArrayList<MinesweeperField>();
		double highestProbability = -1;
		
		for (FieldGroup<MinesweeperField> group : groups) {
			if (group.getProbability() > highestProbability) {
				highestProbability = group.getProbability();
				highProbabilityFields.clear();
				highProbabilityFields.addAll(group);
			}
			else if (group.getProbability() == highestProbability) {
				highProbabilityFields.addAll(group);
			}
		}
		////////////// Om det �r "open-field" klick, klicka intill en mina.
		if (highProbabilityFields.size() > 8){

			List<MinesweeperField> highProbabilityCleaner = new ArrayList<MinesweeperField>(highProbabilityFields);

			for (MinesweeperField checkAdjacents : highProbabilityFields) {
				boolean hasMineAdjacent = false;
				for (MinesweeperField invertedAdjacents : checkAdjacents.getInvertedNeighbors()) {
					if (invertedAdjacents.isMine() && invertedAdjacents.isClicked()) {
						hasMineAdjacent = true;
					}
				}

				if (hasMineAdjacent == false) {
					highProbabilityCleaner.remove(checkAdjacents);
				}
			}

			if (highProbabilityCleaner.size() > 0) {
				highProbabilityFields = highProbabilityCleaner; // f�lt som �r intill en mina och har h�g sannolikhet
			}
			////////////
			
			List<MinesweeperField> highProbabilityFieldsClone = new ArrayList<MinesweeperField>(highProbabilityFields); 
			cleanOpenFields(highProbabilityFieldsClone);

			if (highProbabilityFieldsClone.isEmpty()) {
				// Adds the fields that has a clicked adjacent mine to highProbabilityFieldsClone
				for (MinesweeperField field : pp.getMap().getIteration()) {
					if (hasAdjacentClickedMine(field) && !field.isClicked()) {
						highProbabilityFieldsClone.add(field);
					}
				}
				
				List<MinesweeperField> safeDive = new ArrayList<MinesweeperField>();
				for (MinesweeperField field : highProbabilityFieldsClone) {
					//if the field has a mineProbability higher than 0 then it's a safe dive
					if (gameAnalyze.getGroupFor(field).getProbability() > 0) {
						safeDive.add(field);
					}
				}
				//if no safeDive was found then use the remaining safeClics
				if (safeDive.isEmpty()) {
					if (!highProbabilityFieldsClone.isEmpty())
					{
						highProbabilityFields = highProbabilityFieldsClone;
					}
				}
			}
		}
		/////////////////
		Random random = new Random();
		int clickIndex = random.nextInt(highProbabilityFields.size());
		
		return pp.createMove(MinesweeperMove.STANDARD_CLICK, highProbabilityFields.get(clickIndex));
	}

	private boolean hasAdjacentClickedMine (MinesweeperField field) {
		
		for (MinesweeperField adjacent : field.getNeighbors()) {
			if (adjacent.isDiscoveredMine())
				return true;
		}
		return false;
	}
	
	private MinesweeperField eredags(MinesweeperPlayingPlayer pp, AnalyzeResult<MinesweeperField> gameAnalyze) {
		
		List<MinesweeperField> bombPossibilitys = new ArrayList<MinesweeperField>();
		
		Map<MinesweeperField,List<MinesweeperField>> bombFields = new HashMap<MinesweeperField,List<MinesweeperField>>();
		
		for (MinesweeperField bombCheck : pp.getMap().getIteration()) {
			List<MinesweeperField> bombField = new ArrayList<MinesweeperField>(getBombAdjacents(bombCheck));
			if (bombField.size() > 0) {
				bombFields.put(bombCheck, getBombAdjacents(bombCheck));
			}
		}
		
		double mineProbability = 0;
		
		for (Entry<MinesweeperField, List<MinesweeperField>> bombField : bombFields.entrySet()) {
			
//			Map<MinesweeperField,Double> tempMineProbability = new HashMap<MinesweeperField, Double>();
			double tempMineProbability = pp.getScore();
			for (MinesweeperField field : bombField.getValue()) {
				if (gameAnalyze.getGroupFor(field) != null)
					tempMineProbability += gameAnalyze.getGroupFor(field).getProbability();
			}
			
//			Minesweeper.getServer().log("tempMineProbability :" + tempMineProbability);
//			Minesweeper.getServer().log("mineProbability :" + mineProbability);
			
			
			if (tempMineProbability == mineProbability) {
				bombPossibilitys.add(bombField.getKey());
			}
			else if (tempMineProbability > mineProbability) {
				bombPossibilitys.clear();
				bombPossibilitys.add(bombField.getKey());
				mineProbability = tempMineProbability;
			}
		}
		
//		Minesweeper.getServer().broadcastLobbyChat("mineProbability " + mineProbability);
//		for (MinesweeperField bombableField : bombPossibilitys) {
//			Minesweeper.getServer().broadcastLobbyChat("field is :" + String.format("(%d,  %d)", bombableField.getX(), bombableField.getY()));
//		}
		
		if (mineProbability >= (double) pp.getMap().getMinesCount() / pp.getMap().getPlayingPlayers().size()) {
			return UtilZomisList.getRandom(bombPossibilitys);
		}
		return null;
	}

	static public List<MinesweeperField> getBombAdjacents(MinesweeperField field) {
		
		List<MinesweeperField> bombAdjacents = new ArrayList<MinesweeperField>();
		
		int x = field.getX(), y = field.getY();		
		
		for (int yy = -2 ; yy <= 2 ; yy++) {
			for (int xx = -2 ; xx <= 2 ; xx++) {
				if ((x + xx >= 0 && x + xx < field.getMap().getFieldWidth()) && ( y + yy >= 0 && y + yy < field.getMap().getFieldHeight()))
					bombAdjacents.add(field.getRelativePosition(xx, yy));
			}
		}
		
		return bombAdjacents;
	}
	
	/**
	 * kolla alla f�lt
	 * om minsannolikheten �r st�rre till havs �n vad den �r vid andra nuffror.
	 * 		klicka d� vid en s�ker dykning (adjacent till en redan hittad mina som inte �r i n�rheten av en nuffra)
	 * 
	 */
	
	private void cleanOpenFields(List<MinesweeperField> fields) {
		
		for (MinesweeperField field : new ArrayList<MinesweeperField>(fields)) {
			Collection<MinesweeperField> adjacents = field.getNeighbors();
			boolean hasMine = false;
			for (MinesweeperField adjacent : adjacents) {
				if (adjacent.isDiscoveredMine()) {
					hasMine = true;
					break;
				}
			}
			if (!hasMine) {
				fields.remove(field);
			}
		}
	}
	
	@Override
	public boolean respondToInvite(Invite invite) {
		return true;
	}

}