package net.zomis.plugin.classic;

import java.util.Random;

import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.EndShowMines;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.game.*;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class WinByLose extends MinesweeperPlugin implements EventRegistrator {
	private Random rand = new Random();
	
	public void onEliminate(PlayerEliminateCheckEvent event) {
		event.setCancelled(true);
		
		MinesweeperPlayingPlayer player = event.getPlayingPlayer();
		
		for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers())
		if (pp != player) {
			if (pp.getScore() + event.getMap().getMinesLeft() > player.getScore()) return;
		}
		
		// If no player can get more score than me, then I have lost.
		player.eliminateLoss();
	}
	
	public void onFirstClick(PlayerMoveEvent event) {
		if (event.getMap().getMoveHistory().isEmpty()) {
			MineprobabilityAnalyze analyze = new MineprobabilityAnalyze(event.getMap());
			
			MinesweeperField field = event.getMove().getField();
			analyze.addRule(MineprobabilityAnalyze.ruleForField(field, false));
			analyze.addRule(MineprobabilityAnalyze.ruleFromField(field, 0));
			AnalyzeResult<MinesweeperField> solve = analyze.solve();
			MineprobHelper.regenerate(event.getMap(), solve, rand); // This method modifies the map, and MfeGame takes care of database.
		}
	}
	
	@Override
	public void onDisable() {
	}

	@Override
	public void onEnable() {
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer arg0) {
		return true;
	}

	@Override
	public void registerEvents(EventRegister events) {
		events.registerListener(GameEndedEvent.class, new EndShowMines());
		events.registerListener(GamePreGenerateEvent.class, StandardNeighbors.classicNeighbors);
		events.registerListener(GameInitEvent.class, new StandardWeapons());
		events.registerListener(PlayerEliminateCheckEvent.class, new Consumer<PlayerEliminateCheckEvent>() {
			@Override
			public void accept(PlayerEliminateCheckEvent playerEliminateCheckEvent) {
				onEliminate(playerEliminateCheckEvent);
			}
		});
		events.registerListener(PlayerMoveEvent.class, new Consumer<PlayerMoveEvent>() {
			@Override
			public void accept(PlayerMoveEvent playerMoveEvent) {
				onFirstClick(playerMoveEvent);
			}
		});
	}
}
