package net.zomis.mfe.generate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.api.ai.AISupplier;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class GenerateEndGame {
	public static void generateWithMinesLeft(MinesweeperMap map, AISupplier aiClass, int minesLeft) {
		while (map.getMinesLeft() > minesLeft) {
			MinesweeperAI ai = map.getMapFactory().ai(map.getCurrentPlayer(), aiClass);
			map.performMove(ai.play(map.getCurrentPlayer()));
			evenScore(map);
		}
		evenScore(map);
	}
	public static void generateWithTotal(MinesweeperMap map, AISupplier aiClass, double solutionLimit) {
		AnalyzeProvider analyze = AnalyzeFactory.analyze(map, false);
		while (analyze.getAnalyze().getTotal() > solutionLimit) {
			MinesweeperAI ai = map.getMapFactory().ai(map.getCurrentPlayer(), aiClass);
			map.performMove(ai.play(map.getCurrentPlayer()));
			analyze = AnalyzeFactory.analyze(map, false);
			evenScore(map);
		}
	}

	public static void evenScore(MinesweeperMap map) {
		int totalScore = 0;
		for (MinesweeperPlayingPlayer pp : map.getPlayingPlayers()) {
			totalScore += pp.getScore();
		}
		double playerCount = map.getPlayingPlayers().size();
		
		for (MinesweeperPlayingPlayer pp : map.getPlayingPlayers()) {
			pp.changeScore(-pp.getScore() + (int)Math.round(totalScore / playerCount));
			totalScore -= pp.getScore();
			playerCount--;
		}
		fixMines(map);
		
	}
	/**
	 * Fix so that the visible mines on the map match the score of players
	 * @param map The map to fix the mines on
	 */
	private static void fixMines(MinesweeperMap map) {
		List<MinesweeperField> mines = getDiscoveredMines(map);
		Collections.shuffle(mines);
		
		for (MinesweeperField ff : mines) {
			MinesweeperPlayingPlayer player = ff.getWhoClicked();
			ff.inactivate();
			player.changeScore(1);
		}
		
		for (MinesweeperPlayingPlayer pp : map.getPlayingPlayers()) {
			for (int i = 0; i < pp.getScore(); i++) {
				MinesweeperField mine = mines.remove(0);
				pp.changeScore(-1); // prevent the following from counting
				mine.activate(pp);
			}
		}
	}
	
	private static List<MinesweeperField> getDiscoveredMines(MinesweeperMap map) {
		List<MinesweeperField> list = new ArrayList<MinesweeperField>();
		for (MinesweeperField ff : map.getIteration()) {
			if (ff.isDiscoveredMine()) list.add(ff);
		}
		return list;
	}
}
