package net.zomis.mario.mfeais;

import net.zomis.mario.classes.Bot;
import net.zomis.mario.classes.Enums.PlayerColor;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class NightmareTools {
	public static char[] unknownLine() {
		return "????????????????".toCharArray();
	}
	public static char[] oneLine() {
		return "??????????????3?".toCharArray();
	}
	public static char[][] megaClone(char[][] matrix) {
		char[][] cloned = new char[matrix.length][];
		for(int i = 0; i < matrix.length; i++)
			cloned[i] = matrix[i].clone();
		return cloned;
	}
	public static char[][] testBoard() {
		return new char[][]{
				unknownLine(), unknownLine(), unknownLine(), unknownLine(),
				unknownLine(), unknownLine(), unknownLine(), unknownLine(),
				unknownLine(), unknownLine(), unknownLine(), unknownLine(),
				unknownLine(), unknownLine(), oneLine()    , unknownLine(),
		};
	};
	public static char[][] emptyBoard() {
		return new char[][]{
			unknownLine(), unknownLine(), unknownLine(), unknownLine(),
			unknownLine(), unknownLine(), unknownLine(), unknownLine(),
			unknownLine(), unknownLine(), unknownLine(), unknownLine(),
			unknownLine(), unknownLine(), unknownLine(), unknownLine(),
		};
	};
	
	public static int count(char[][] logicBoard, char c) {
		int i = 0;
		for (char[] ch : logicBoard)
			for (char cc : ch)
				if (cc == c) i++;
		
		return i;
	}
	
	public static char[][] fixBoard(MinesweeperPlayingPlayer player, Bot bot) {
		MinesweeperMap game = player.getMap();
		char[][] result = new char[game.getFieldWidth()][game.getFieldHeight()];
		for (MinesweeperField field : game.getIteration()) {
			char ch = fixChar(player, bot, field);
			result[field.getY()][field.getX()] = ch; // mario's code is structured as [y][x]
			
//			if (ai != null) ai.sendChatMessage(String.format("(%d, %d) clicked %b | mine %b | discovered mine %b | who clicked %s | knownValue %c", 
//					field.getX(), field.getY(), field.isClicked(), field.isMine(), field.isDiscoveredMine(), field.getWhoClicked(), (char) ('0' + field.getKnownValue())));
		}
		
		return result;
	}

	public static char fixChar(MinesweeperPlayingPlayer player, Bot bot, MinesweeperField field) {
		if (!field.isClicked()) return '?';
		
		if (field.isDiscoveredMine()) {
			if (field.getWhoClicked() == null) return 'm';
			
			boolean isBlue = PlayerColor.BLUE.equals(bot.getPlayerColor());
			
			if (field.getWhoClicked().getIndex() == player.getIndex()) {
				return isBlue ? 'b' : 'r';
			}
			else {
				return isBlue ? 'r' : 'b';
			}
		}
		
		return (char) ('0' + field.getKnownValue());
	}
}
