package net.zomis.mario.classes;

	public class Configuration
    {
		public boolean FASTMODE;
		public int MINES;
		public int DIMH;
		public int DIMV;
		public boolean PARETO;
		public int MAXLEVEL;
		public Enums.LogLevel LOGLEVEL;
		public int BOTDELAY;
		public Enums.Difficult BLUEDIFFICULT;
		public Enums.Difficult REDDIFFICULT;
        public Enums.PlayerType REDPLAYERTYPE;
        public Enums.PlayerType BLUEPLAYERTYPE;

        public static Configuration BasicConfig()
        {
                Configuration configuration = new Configuration();

                configuration.MINES = 51;
                configuration.DIMH = 16;
                configuration.DIMV = 16;

                return configuration;
        }

		public static Configuration SolverConfig()
		{
				Configuration configuration = new Configuration();

				configuration.MINES = 51;
				configuration.DIMH = 16;
				configuration.DIMV = 16;

				configuration.FASTMODE = true;
				configuration.PARETO = false;
				configuration.LOGLEVEL = Enums.LogLevel.INFO;
				configuration.MAXLEVEL = 1;

				return configuration;
		}

		public static Configuration TrainingConfig()
		{
				Configuration configuration = new Configuration();

				configuration.MINES = 51;
				configuration.DIMH = 16;
				configuration.DIMV = 16;

				configuration.FASTMODE = true;
				configuration.PARETO = false;
				configuration.REDDIFFICULT = Enums.Difficult.MEDIUM;
				configuration.BLUEDIFFICULT = Enums.Difficult.MEDIUM;
				configuration.LOGLEVEL = Enums.LogLevel.ERROR;
				configuration.BOTDELAY = 0;
                configuration.BLUEPLAYERTYPE = Enums.PlayerType.HUMAN;
                configuration.REDPLAYERTYPE = Enums.PlayerType.BOT;

				return configuration;
		}
   }
