package net.tejpbit.ais;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Random;

import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

// @AI(rating = -99999)
public class AI_Loser extends MinesweeperAI {

	public AI_Loser() {
		super("#AI_Loser");
	}

	@Override
	public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
		return false;
	}
	
	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		AnalyzeResult<MinesweeperField> gameAnalyze = AnalyzeFactory.analyze(pp.getMap(), false).getAnalyze();
		
		if (pp.canUseWeapon(MinesweeperMove.STANDARD_BOMB) && pp.getMap().getAllUnclickedFields().size() ==
				pp.getMap().getMinesLeft()) {
			MinesweeperField bombField = eredags(pp);
			if (bombField != null) {
				return pp.createMove(MinesweeperMove.STANDARD_BOMB, bombField);
			}
		}
		
		
		List<FieldGroup<MinesweeperField>> groups = gameAnalyze.getGroups();
		List<MinesweeperField> lowProbabilityFields = new ArrayList<MinesweeperField>();
		double lowestProbability = 42.42;
		
		for (FieldGroup<MinesweeperField> group : groups) {
			if (group.getProbability() < lowestProbability) {
				lowestProbability = group.getProbability();
				lowProbabilityFields.clear();
				lowProbabilityFields.addAll(group);
			}
			else if (group.getProbability() == lowestProbability) {
				lowProbabilityFields.addAll(group);
			}
		}
		//////////////
		List<MinesweeperField> lowProbabilityCleaner = new ArrayList<MinesweeperField>(lowProbabilityFields);
		
		for (MinesweeperField checkAdjacents : lowProbabilityFields) {
			boolean hasMineAdjacent = false;
			for (MinesweeperField invertedAdjacents : checkAdjacents.getInvertedNeighbors()) {
				if (invertedAdjacents.isMine() && invertedAdjacents.isClicked()) {
					hasMineAdjacent = true;
				}
			}
			
			if (!hasMineAdjacent) {
				lowProbabilityCleaner.remove(checkAdjacents);
			}
		}
		
		if (lowProbabilityCleaner.size() > 0) {
			lowProbabilityFields = lowProbabilityCleaner;
		}
		 ////////////
		Random random = new Random();
		int clickIndex = random.nextInt(lowProbabilityFields.size());
		
		return pp.createMove(MinesweeperMove.STANDARD_CLICK, lowProbabilityFields.get(clickIndex));
	}

	private MinesweeperField eredags(MinesweeperPlayingPlayer pp) {
		
		Map<MinesweeperField, Integer> bombableFields = new HashMap<MinesweeperField, Integer>();
		
		List<MinesweeperField> fields = new ArrayList<MinesweeperField>(pp.getMap().getAllFields());
		
		for (MinesweeperField field : fields) {
			if (field.getX() >= 2 && field.getX() <= pp.getMap().getFieldWidth() - 3 && field.getY() >= 2
				&& field.getY() <= pp.getMap().getFieldHeight() - 3) {
				
				int mines = 0;
				for (MinesweeperField bombAdjacent : TejpbitAI_Hard.getBombAdjacents(field)) {
					if (!bombAdjacent.isClicked()) {
						mines++;
					}
				}
				bombableFields.put(field, mines);
			}
			
		}
		
		List<MinesweeperField> finalBombFields = new ArrayList<MinesweeperField>();
		int lowestMineCount = 42;
		for (Entry<MinesweeperField, Integer> bombField : bombableFields.entrySet()) {
			if (bombField.getValue() < lowestMineCount && bombField.getValue() != 0) {
				finalBombFields.clear();
				lowestMineCount = bombField.getValue();
				finalBombFields.add(bombField.getKey());
			}
			else if (bombField.getValue() == lowestMineCount) {
				finalBombFields.add(bombField.getKey());
			}
		}
		
		return finalBombFields.get(new Random().nextInt(finalBombFields.size()));
	}

	@Override
	public boolean respondToInvite(Invite invite) {
		return true;
	}

}
