package net.zomis.plugin;

import java.util.ArrayList;
import java.util.List;

import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.game.GameStartEvent;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class OpenFieldChallenge extends MinesweeperPlugin implements EventRegistrator {
	private final double thinkProbability = 1.0;
	private List<MinesweeperField> needed100 = new ArrayList<MinesweeperField>();
	private MineprobabilityAnalyze analyze;
	
	public void getMineProbabilityOfMove(PlayerMoveEvent event) {
		if (event.getPlayer().getGame() == null) return;
		
		double chosen = MineprobHelper.getMineProbabilityForField(event.getMove().getMovePosition());
		if (Math.abs(chosen - thinkProbability) <= 0.0001) {
			needed100.remove(event.getMove().getMovePosition());
			event.getGame().sendChatMessage("MineprobChallenge: Well done! Remaining: " + needed100);
			if (needed100.isEmpty()) {
				this.startChallenge(event.getGame(), event.getMove().getMovePosition());

//				if (event.getGame().getMinesLeft() == 0) event.setCancelled(true);
				if (!event.getMove().getMovePosition().isMine()) event.setCancelled(true);
			}
		}
		else {
			event.getGame().sendChatMessage("MineprobChallenge: Sorry. I asked you to find a field with probability of " + this.thinkProbability + " but you found one with " + chosen);
			event.setCancelled(true);
			event.getMove().getMovePosition().sendInfoToPlayers();
		}
		
	}
	
	private void startChallenge(MinesweeperGame game, MinesweeperField ignore) {
		needed100.clear();
		int safety = 0;
		while (needed100.isEmpty()) {
			this.createSomethingRandom(game);
			this.analyze = new MineprobabilityAnalyze(game);
			AnalyzeResult<MinesweeperField> solution = this.analyze.solve();
			for (FieldGroup<MinesweeperField> group : solution.getGroups()) {
				if (group.getProbability() >= 0.99999) needed100.addAll(group);
			}
			if (ignore != null) needed100.remove(ignore);
			
			if (safety++ >= 100) break;
		}
		game.sendChatMessage("MineprobChallenge: I want you to click on " + needed100 + " fields with Mineprobability " + this.thinkProbability);
	}
	
	public void onChallengeStart(GameStartEvent event) {
		this.startChallenge(event.getGame(), null);
	}
	
	private void createSomethingRandom(MinesweeperGame game) {
		game.getPlayingPlayers().get(0).changeScore(1);
		MinesweeperMove move;
		
		move = game.getMapFactory().ai(game.getCurrentPlayer(),
            game.getServer().getAI("#AI_OpenField")).play(game.getCurrentPlayer());
		if (move != null && move.getWeapon() != null)
			move.getWeapon().useAt(move);
		else game.sendChatMessage("Move could not be made: " + move);
			
		if (move.getMovePosition().getValue() > 0 && !move.getMovePosition().isMine()) {
			game.generate();
			createSomethingRandom(game);
		}
		else if (move.getMovePosition().isMine()) createSomethingRandom(game);
			
		game.setCurrentPlayerTurn(0);
		
		for (MinesweeperPlayingPlayer pp : game.getPlayingPlayers()) pp.changeScore(- pp.getScore());
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer player) {
		return player.hasPermission(PlayerCommandEvent.PERMISSION_ADMIN);
	}
/*
 * Server-plugin:
 * - Remove all AIs from game.
 * - add #AI_Open_Field if there is only one player remaining
 * - Pause between new maps (all players must click ready)
 * - Support observers
 * - Cancel default elimination
 * 
 * ? Select difficulty?
 * 
 * Single-player:
 * ? How to show the player's "points * points / second"-score?
 * ? DONE-button? (bomb?)
 * ? Save last score between rounds and submit that when fail
 * - View taken 100% mines as player score for client
 * 
 * Multiplayer:
 * - Use ACTION MODE
 * 
 * 
 * 
 * 
 **/
	@Override
	public void onDisable() {
		
	}

	@Override
	public void onEnable() {
/*		this.registerListener(new DefaultExpanderRule());
		this.registerListener(new StandardNeighbors());
		this.registerListener(new StandardWeapons());
		this.registerListener(this);*/
	}

	@Override
	public void registerEvents(EventRegister events) {
		throw new UnsupportedOperationException();
	}
}
