package net.zomis.minesweeper.scores;

import java.util.Collections;
import java.util.List;



public class ScoreConfig {
	private final ScoreSet scorers;
	private final List<PostScorer> postScorers;
	private final AnalyzeMethod analyzeMethod;
	private boolean detailed;
	private final List<PreScorer> preScorers;
	
	public ScoreConfig(AnalyzeMethod analyzeMethod, List<PreScorer> preScorers, List<PostScorer> postScorers, ScoreSet scorers) {
		this.analyzeMethod = analyzeMethod;
		this.postScorers = Collections.unmodifiableList(postScorers);
		this.preScorers = Collections.unmodifiableList(preScorers);
		this.scorers = scorers;
	}

	public AnalyzeMethod getAnalyzeMethod() {
		return analyzeMethod;
	}

	public List<PostScorer> getPostScorers() {
		return postScorers;
	}

	public ScoreSet getScorers() {
		return scorers;
	}

	public boolean isDetailed() {
		return detailed;
	}
	/**
	 * Set whether or not each FieldScore should contain detailed information about how much score the field got from all different scorers (including post scorers)
	 * @param detailed True if detailed, false otherwise.
	 */
	public void setDetailed(boolean detailed) {
		this.detailed = detailed;
	}
	public List<PreScorer> getPreScorers() {
		return preScorers;
	}
}
