package net.zomis.minesweeper.analyze.impl;

import java.util.ArrayList;
import java.util.List;

import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.AnalyzeFactory;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;

public class MineprobabilityAnalyze extends AnalyzeFactory<MinesweeperField> {
	private final MinesweeperMap game;
	public MineprobabilityAnalyze(MinesweeperMap game) {
		this.game = game;
		this.createRules();
	}
	private final List<MinesweeperField> knownNonMines = new ArrayList<MinesweeperField>();

	private final void createRules() {
		this.addRule(new FieldRule<MinesweeperField>(null, game.getAllUnclickedFields(), game.getMinesLeft()));
		for (MinesweeperField field : game.getIteration()) {
			if (!field.isClicked() || field.isMine() || field.isBlocked())
				continue;

			FieldRule<MinesweeperField> newRule = internalRuleFromField(field, true);
			if (newRule != null && !newRule.isEmpty()) {
				this.addRule(newRule);
//				game.getServer().log(newRule.toString());
			}
		}
		if (!knownNonMines.isEmpty())
			this.addRule(new FieldRule<MinesweeperField>(null, knownNonMines, 0));
	}
	
	private FieldRule<MinesweeperField> internalRuleFromField(MinesweeperField field, boolean addNonMines) {
		List<MinesweeperField> ruleParams = new ArrayList<MinesweeperField>();
		int foundNeighbors = 0;

		for (MinesweeperField neighbor : field.getNeighbors()) {
			if (neighbor.isDiscoveredMine()) 
				foundNeighbors++;
			else if (!neighbor.isClicked())
				ruleParams.add(neighbor);
		}
		
		if (field.getValue() - foundNeighbors == 0) {
			if (addNonMines) {
				for (MinesweeperField mf : ruleParams)
					if (!this.knownNonMines.contains(mf)) this.knownNonMines.add(mf);
			}
			return null;
		}
		else return new FieldRule<MinesweeperField>(field, ruleParams, field.getValue() - foundNeighbors);
	}
	
	public FieldRule<MinesweeperField> ruleFromField(MinesweeperField field) {
		return this.internalRuleFromField(field, false);
	}

	public static FieldRule<MinesweeperField> ruleForField(MinesweeperField field, boolean isMine) {
		List<MinesweeperField> ruleParams = new ArrayList<MinesweeperField>();
		ruleParams.add(field);
		return new FieldRule<MinesweeperField>(field, ruleParams, isMine ? 1 : 0);
	}
	public static FieldRule<MinesweeperField> ruleFromField(MinesweeperField field, int result) {
		List<MinesweeperField> ruleParams = new ArrayList<MinesweeperField>();

		for (MinesweeperField neighbor : field.getNeighbors()) {
			if (!neighbor.isClicked())
				ruleParams.add(neighbor);
		}
//		ruleParams.add(field); // Field itself should not be able to be a mine! - A seperate rule needs to be added for this!
		return new FieldRule<MinesweeperField>(field, ruleParams, result);
	}

}
