package net.zomis.minesweeper.analyze.endgame;

import java.util.Arrays;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.endgame.WinChanceTools.WinResult;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.model.MapUtils;

public class WinChanceData implements Comparable<WinChanceData> {
	private final MinesweeperMove move;

	private double instantLoss = 0;
	private double instantWin = 0;
	
	public WinChanceData(MinesweeperMove move) {
		this.move = move;
	}

	public void analyzeBomb(AnalyzeProvider analyze) {
	}
// Analyze http://stats.zomis.net/map/______1ba1000011-_1x_11222100001b-_____a1001110133-xx_x_11001a101bb-__2__11212110233-11____b4b20012b1-b2____3bb2013b42-b32___2b5312baa2-13bb1134aa23baa2-13a322ab444b4a31-2a211a322ab43210-b210111013b4a222-22100000012b23aa-1a101110001124a4-22201b1000001aa2-1b10111000001221

	// TODO Analyze!!!   http://stats.zomis.net/map/00000122102b21aa-111012ab102b3233-2a212a321124b32a-2b32a32002a5a4b2-12a22a1113bb4b21-01111111a223b321-12222233211233a1-b3ab3aaa1_1b2a21-2b323a421_113220-122122311__12b10-01a11a2b1_13b420-121111211_1aba31-b21________24b3b-2a1______a_12121-33______113b2000-bb_x______2b2000
	// TODO in the map above, (9 7) and (9 8) is basically the same move, don't (recursive-)analyze both.
	// TODO filter out the bad moves, focus on the good ones, and perform recursiveness.
	public void analyzeClick(AnalyzeProvider analyze) {
		ProbabilityKnowledge<MinesweeperField> data = analyze.getKnowledgeFor(move.getField());
		
//		analyze.getAnalyze().getTotal();
		
		double[] probs = data.getProbabilities();
		for (int i = 0; i < probs.length; i++) {
			if (probs[i] > 0) {
				this.testWithValues(probs[i], move.getField(), false, i, analyze.getAnalyze());
			}
		}
		if (data.getMineProbability() > 0)
			this.testWithValues(data.getMineProbability(), move.getField(), true, 0, analyze.getAnalyze());
		
	}

	private MinesweeperMap testWithValues(double probability, MinesweeperField field, boolean isMine, int value, AnalyzeResult<MinesweeperField> rootAnalyze) {
		MinesweeperMap map = MapUtils.copyMap(field.getMap());
		UtilZomisUtils.echo("testWithValues " + probability + " " + field + " is " + isMine + " val " + value);
		AnalyzeResult<MinesweeperField> analyze;
		
		testAnalyze(rootAnalyze);

		if (!isMine) {
            analyze = rootAnalyze.cloneAddSolve(Arrays.<RuleConstraint<MinesweeperField>>asList(MineprobabilityAnalyze.ruleForField(field, false),
                MineprobabilityAnalyze.ruleFromField(field, value - ZomisTools.fieldFoundMines(field))));
        }
		else analyze = rootAnalyze.cloneAddSolve(Arrays.<RuleConstraint<MinesweeperField>>asList(MineprobabilityAnalyze.ruleForField(field, true)));
		testAnalyze(analyze);
		MineprobHelper.regenerate(map, analyze, null);
		
		if (!isMine && value == 0) {
			// open field, loop through all possible combinations of the map
			for (double combo = 0; combo < analyze.getTotal(); combo++) {
				MinesweeperMap copy = MapUtils.copyBase(map).loadMap(field.getMap().saveMap());
				MineprobHelper.fixRemainingMines(copy, analyze.getSolution(combo));
				MinesweeperMove newmove = this.moveToMap(copy);
				copy.performMove(newmove);
				this.checkForEnding(probability * 1 / analyze.getTotal(), copy, AnalyzeFactory.analyze(copy, false).getAnalyze());
			}
		}
		else {
			MinesweeperMove newmove = this.moveToMap(map);
			map.performMove(newmove);
			this.checkForEnding(probability, map, analyze);
		}
		return map;
	}

	private MinesweeperMove moveToMap(MinesweeperMap map) {
		MinesweeperPlayingPlayer player = map.getPlayingPlayers().get(move.getPlayer().getIndex());
		return map.createMove(player, player.getWeapon(move.getWeaponType()), map.getPosition(move.getField()));
	}

	private void testAnalyze(AnalyzeResult<MinesweeperField> analyze) {
//		ZomisUtils.echo("Echo " + analyze);
		MinesweeperMap map = null;
		for (FieldGroup<MinesweeperField> fg : analyze.getGroups()) {
			for (MinesweeperField ff : fg) {
				if (map == null) map = ff.getMap();
				if (map != ff.getMap()) throw new AssertionError("different maps: " + ff + " in group " + fg);
			}
		}
	}

	private void checkForEnding(double probability, MinesweeperMap map, AnalyzeResult<MinesweeperField> analyze) {
//		if (true) return;
		
		WinResult ending = WinChanceTools.checkDirectEnding(map.getPlayingPlayers().get(move.getPlayer().getIndex()), analyze);
		if (ending == null) return;
		if (ending == WinResult.DRAW) {
			UtilZomisUtils.echo(this.move.getMoveString() + " DRAW with prob " + probability);
			instantLoss += probability / 2;
			instantWin += probability / 2;
		}
		if (ending == WinResult.LOSS) {
			UtilZomisUtils.echo(this.move.getMoveString() + " LOSS with prob " + probability);
			instantLoss += probability;
		}
		if (ending == WinResult.WIN) {
			UtilZomisUtils.echo(this.move.getMoveString() + "  WIN with prob " + probability);
			instantWin += probability;
		}
	}
	
	public double getWinExpected() {
		return instantWin - instantLoss;
	}
	
	@Override
	public String toString() {
		return this.move.getMoveString() + ": " + this.getWinExpected();
	}

	@Override
	public int compareTo(WinChanceData o) {
		return (int) (1000 * (this.getWinExpected() - o.getWinExpected()));
	}
}
