package net.zomis.minesweeper.aiscore;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class SafeProbabilityAroundMine extends AbstractScorer {
	@Override
	public double getScoreFor(MinesweeperField field,
			ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		if (!this.isInterestingField(field, data, scores.getWeapon())) return 0;
		
		if (!ZomisTools.isZomisOpenField(field)) return 0; // Modified because of 012a2123a2___1b1-01b33a2aa41_1221-012b3234aa1_1a1_-1122a11a321_111_-1b1111111_______-332_____________-aa1_____________-221__xx______x__-_______________x-__111____111____-x_1a1_1122a32_x_-x_11213a3a5aa4b3-___13a4a43abb__x-1234aa313b432___-2aaaa3214a422___-a4a4211a3a3aa1_x
		
		double[] probabilities = data.getProbabilities();
		
		for (int i = probabilities.length - 1; i >= 0; i--) {
			if (probabilities[i] > 0) {
				double prob = data.getMineProbability() - (probabilities[i] * (i - data.getFound()));
				
				return prob / 10;
			}
		}
		if (data.getMineProbability() > 0.99) return 0;
		throw new AssertionError("Something is horribly wrong with these probabilities: " + data);
	}

	public boolean isInterestingField(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, MinesweeperWeapon weapon) {
		return data.getMineProbability() > 0 && (data.getFound() > 0 || data.getProbabilities()[0] == 0);
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return this.weaponIsClick(scores.getWeapon());
	}
}
