package net.zomis.minesweeper.aiscore;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class CertainMines extends AbstractScorer {
	private static double MINE_THRESHOLD = 0.9999;
	public static double POWER = 100; // changed from 10 to 100 because of game 1062693
	
	@Override
	public double getScoreFor(MinesweeperField field,
			ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		if (data == null) return 0;
		if (data.getMineProbability() >= MINE_THRESHOLD) return data.getMineProbability() * POWER;
		else return 0;
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return this.weaponIsClick(scores.getWeapon());
	}
}
