package net.zomis.minesweeper.ais.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.zomis.UtilZomisList;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.api.ai.AISupplier;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScores;

public class AICompare {
	private final MinesweeperMap map;
	private final List<AISupplier> ais;
	
	public AICompare(MinesweeperMap map, AISupplier... ais) {
		this.map = map;
		this.ais = new ArrayList<AISupplier>(Arrays.asList(ais));
	}
	
	private boolean compareNext(boolean performMove) {
		List<AI_Zomis> realAIs = new ArrayList<AI_Zomis>();
        MinesweeperPlayingPlayer pp = map.getCurrentPlayer();
		for (AISupplier ai : ais) {
			AI_Zomis realAI = (AI_Zomis) map.getMapFactory().ai(map.getCurrentPlayer(), ai);
			realAIs.add(realAI);
		}
		if (realAIs.size() != ais.size()) throw new IllegalStateException();
		
		List<List<FieldScore>> bestRankings = new ArrayList<List<FieldScore>>();
		
		MinesweeperMove theMove = null;
		
		for (AI_Zomis ai : realAIs) {
//			logger.info("" + ai.getMap());
			
			MinesweeperMove move = ai.play(pp);
			if (move == null) throw new AssertionError("move null");
			FieldScores scores = ai.createScoreProvider(pp).analyzeAndScore(move.getWeapon(), false);
			theMove = move;
			List<FieldScore> rankings = scores.getBestFields();
			
			bestRankings.add(rankings);
		}
		
		for (List<FieldScore> a : bestRankings) {
			for (List<FieldScore> b : bestRankings) {
				if (!FieldScores.listsEquals(a, b)) return false;
			}
		}

        if (theMove == null) {
            throw new NullPointerException("Move was null");
        }
		
		if (performMove) {
			if (!theMove.getMap().performMove(theMove).isOK()) throw new IllegalStateException("Could not make move " + theMove);
		}
		else {
			if (!theMove.getMoveAllowedState().isOK()) throw new IllegalStateException("Impossible move returned " + theMove);
		}
		
		return true;
	}
	
	public boolean compareNext() {
		return this.compareNext(true);
	}

	public boolean solveConflict() {
		if (!this.compareNext(false)) {
			AI_Zomis ai = (AI_Zomis) map.getMapFactory().ai(map.getCurrentPlayer(), UtilZomisList.getRandom(this.ais));
			MinesweeperMove move = ai.play(map.getCurrentPlayer());
			return move.getMap().performMove(move).isOK();
		}
		return false;
	}
}
