package net.zomis.minesweeper.ais;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.SortedSet;

import net.zomis.UtilZomisList;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.ai.AISupplier;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScoreProducer;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.scores.ScoreConfig;
import net.zomis.minesweeper.scores.ScoreProducer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public abstract class AI_Zomis extends MinesweeperAI implements ScoreProducer {
/*
 * Put priorities on the AbstractScorers ?
 *  to avoid OnlyOpenFields if there is a SafeSpotsAroundMines scorer. 
 *  Or analyze EV after having found out which fields to analyze EV for.
 **/
	private final ScoreConfig config;
	
	@Override
	public ScoreConfig getConfig() {
		return config;
	}
	
	private AISupplier backup = null;
	
	private Map<MinesweeperWeapon, FieldScores>	lastScores = new HashMap<MinesweeperWeapon, FieldScores>();

	public AI_Zomis(String name, ScoreConfig config) {
		super(name);
		this.config = config;
	}

	@Deprecated
	public Map<MinesweeperWeapon, FieldScores> getLastScores() {
		return new HashMap<MinesweeperWeapon, FieldScores>(lastScores);
	}
	@Override
	public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
		return MineprobHelper.isDraw(pp.getMap());
	}
	
	protected MinesweeperMove playWithDrawproposal(MinesweeperPlayingPlayer pp) {
/*		if (this.agreeDraw(pp)) {
			if (this.getPlayingPlayer().proposeDraw()) {
				this.sendChatMessage("I propose draw! You've got 10 seconds to agree or not");
				
				if (!this.getPlayingPlayer().isEliminated()) {
					try { Thread.sleep(10000);	}	catch (InterruptedException e) {}
				}
				
				if (!this.getPlayingPlayer().isEliminated()) this.sendChatMessage("10 seconds has passed, now I make my move.");
			}
		}*/
		
		return this.internalplay(pp);
	}
	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		return this.internalplay(pp);
	}
	private MinesweeperMove internalplay(MinesweeperPlayingPlayer pp) {
		Map<MinesweeperWeapon, List<FieldScore>> bestMoves = new HashMap<MinesweeperWeapon, List<FieldScore>>();
		Map<MinesweeperMove, Double> moves;
		
		if (pp.getWeapons().isEmpty()) throw new IllegalStateException("No weapons for AI: " + pp);
		long time = System.nanoTime();

		FieldScoreProducer scoreProvider = new FieldScoreProducer(pp, getConfig());
		
		if (!scoreProvider.analyze()) {
			String backupName = this.backup == null ? "null" : this.backup.toString();
			this.sendChatMessage(pp, "Map layout too complex. I ask my backup: " + backupName);
			if (this.backup == null) {
				this.sendChatMessage(pp, "I could not find my backup " + backupName + ". I'm screwed!");
			}
			return backup.get(pp).play(pp);
		}
		
		moves = new HashMap<MinesweeperMove, Double>();
		
		this.lastScores.clear();
		
		for (MinesweeperWeapon weapon : pp.getWeapons()) {
			if (!weapon.canUse(pp)) {
				continue;
			}
			
			FieldScores scores = scoreProvider.score(weapon); // TODO: Use the same analyze as earlier within this method. No need to analyze once per weapon.
			this.lastScores.put(weapon, scores);
			
			if (scores == null) {
				return backup.get(pp).play(pp);
			}
			
			List<FieldScore> best = scores.getBestFields();
			bestMoves.put(weapon, best);
			if (best.isEmpty()) continue;
			
			FieldScore chosen = UtilZomisList.getRandom(best);
			MinesweeperMove move = pp.createMove(weapon.getWeaponType(), chosen.getField());
			moves.put(move, chosen.getScore());
		}
		
		SortedSet<Entry<MinesweeperMove, Double>> sortedMoves = UtilZomisList.entriesSortedByValues(moves, true);
		
		MinesweeperMove move = null;
		if (!sortedMoves.isEmpty()) move = sortedMoves.iterator().next().getKey();
		time = System.nanoTime() - time;
		
		return move;
	}

	@Override
	public boolean respondToInvite(Invite invite) {
		return true;
//		return hostIsWithinXRatingOfAI(invite, this, 800);
	}

	public void setBackup(AISupplier backup) {
		this.backup = backup;
	}

	@Override
	public FieldScoreProducer createScoreProvider(MinesweeperPlayingPlayer pp) {
		return new FieldScoreProducer(pp, getConfig());
	}

}
