package net.zomis.mario.classes;

class MinesweeperFlags
{
    /// <summary>
    /// Esta clase permite guardar objetos de tipo desconocido afectados por un recorrido
    /// </summary>
    public class ZonePoint //:IEquatable<ZonePoint>
    {
        public int row;
        public int col;
        public int adjacentTempMines;
        public int[][] adjacents;
        private int maximumAdjacentMines = -1;

        public ZonePoint(int row, int col)
        {
            this.row = row;
            this.col = col;
        }

		public int MaxAdjacentMines()
		{
				if (maximumAdjacentMines != -1)
				{
					return maximumAdjacentMines;
				}

				maximumAdjacentMines = 0;
				for (int i = adjacents[0].length - 1; i > 0; i--)
				{
					for (int j = 0; j < adjacents.length; j++)
					{
						if (adjacents[j][i] != 0)
						{
							maximumAdjacentMines = i;
							return i;
						}
					}
				}

				return maximumAdjacentMines;
		}

//        public static /*explicit operator*/ Point(ZonePoint obj)
//        {
 //           return new Point(obj.row, obj.col);
//        }

		public Point PointValue(){
			return new Point(row,col);
		}
		
        public String toString()
        {
            StringBuilder stringBuilder = new StringBuilder(String.format("(%d,%d)", this.row, this.col));

            stringBuilder.append("\r\n\t\t\tAdjacents");
			if (adjacents == null)
			{
				stringBuilder.append("\r\n\t\t\t\tNone");
			}
			else
			{
				stringBuilder.append("\n");
				for (int i = 0; i < adjacents.length; i++)
				{
					stringBuilder.append("\t\t\t");
					for (int j = 0; j < adjacents[0].length; j++)
					{
						stringBuilder.append(((Integer)adjacents[i][j]).toString()/*.PadLeft(4)*/);
					}
					stringBuilder.append("\n");
				}
			}

            return stringBuilder.toString();
        }

//        #region IEquatable<ZonePoint> Members

        public boolean Equals(Object other)
        {
        	if (!(other instanceof ZonePoint)) return false;
        	ZonePoint zonePoint = (ZonePoint) other;
            return (zonePoint.row == this.row && zonePoint.col == this.col);
        }

//        #endregion
        
        public void javaGarbage() {
        	this.adjacents = null;
        }
    }
}
