package net.zomis.minesweeper.analyze.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.game.MinesweeperField;

public class OpenFieldApproxer {
	private double totalProb = 0;
	private AnalyzeProvider	analyze;
	public double floodFill(AnalyzeProvider analyze, MinesweeperField field) {
		Collection<MinesweeperField> ff = new ArrayList<MinesweeperField>();
		totalProb = 0;
		this.analyze = analyze;
		UtilZomisUtils.recursiveAdd(ff, field, new Recursive());
		return totalProb - this.closestMineprobSum(analyze, field);
	}
	
	
	private double closestMineprobSum(AnalyzeProvider analyze, MinesweeperField field) {
		double total = 0;
		
		Collection<MinesweeperField> fields = field.getNeighbors();
		fields.add(field);
		
		for (MinesweeperField ff : fields) {
			ProbabilityKnowledge<MinesweeperField> know = analyze.getKnowledgeFor(ff);
			if (know != null)
				total += know.getMineProbability();
		}
		return total;
	}

	
	
	private class Recursive implements UtilZomisUtils.RecursiveInterface<MinesweeperField> {
		private Set<MinesweeperField> added = new HashSet<MinesweeperField>();
		
		@Override
		public boolean performAdd(MinesweeperField from, MinesweeperField to) {
			if (to.isClicked()) return false;
			if (analyze.getKnowledgeFor(to) == null) return false;
			if (analyze.getKnowledgeFor(to).getProbabilities()[0] <= 0) return false;
			if (added.contains(to)) return false;
			added.add(to);
//			Zomis.echo("Adding " + to);
			totalProb += analyze.getKnowledgeFor(to).getMineProbability();
			return true;
		}

		@Override
		public boolean performRecursive(MinesweeperField from, MinesweeperField to) {
			return !to.isClicked() && analyze.getKnowledgeFor(to) != null &&
					analyze.getKnowledgeFor(to).getProbabilities()[0] > 0;
		}

		@Override
		public Collection<MinesweeperField> getRecursiveFields(MinesweeperField field) {
			return field.getNeighbors();
		}
		
	}
	
	
	public double expectedFrom(AnalyzeProvider analyze, MinesweeperField field) {
		if (field.isClicked()) return 0;
		
		Queue<MinesweeperField> queue;
		Queue<MinesweeperField> nextQ = new LinkedList<MinesweeperField>();
		Set<MinesweeperField> completed = new HashSet<MinesweeperField>();
		Set<MinesweeperField> finalFields = new HashSet<MinesweeperField>();
		// Perform 3 iterations and count the total mine probability
//		double total = 0;
		double total = analyze.getKnowledgeFor(field).getMineProbability();
		int iterations = 0;
		nextQ.add(field);
		
		while (iterations < 3) {
			iterations++;
			queue = nextQ;
			nextQ = new LinkedList<MinesweeperField>();
			boolean foundProbability = false;
			
			if (queue.isEmpty()) break;
			
			while (!queue.isEmpty()) {
				MinesweeperField next = queue.poll();
				completed.add(next);
				
				for (MinesweeperField ff : next.getNeighbors()) {
					ProbabilityKnowledge<MinesweeperField> probData = analyze.getKnowledgeFor(ff);
					if (!ff.isClicked() && !nextQ.contains(ff) && !queue.contains(ff) && !completed.contains(ff)) {
						if (probData.getProbabilities()[0] < 1.0) finalFields.add(ff);
						if (probData.getProbabilities()[0] <= 0) continue;
						
						nextQ.add(ff);
						
						if (probData != null) {
							total += probData.getMineProbability();
							if (probData.getMineProbability() != 0) {
								foundProbability = true;
							}
						}
					}
					else if (ff.isClicked()) finalFields.add(ff); // Added fix for 6f in this situation: 2a2_2ba2001a1000-_b2_2bb200122100-232_23310112b210-b_a_2b2001b44b21-_2__2b20123ba22b-_12221112a233322-13ba3222b333b3a2-1aaa3ba212bb34a2-13a322332334a211-_111_13bb3b32200-_____1bb4b33a100-_____12222b32100-_11________b2100-_1a2__xx_xa3b100-_112b22333222210-________a___1a10
					// Don't need to check if it already is added since we're using a HashSet.
				}
				
			}
			
			if (!foundProbability) iterations--;
		}
		
		
		// Added fix for revealing 50% mines and stuff.
		Set<MinesweeperField> extras = new HashSet<MinesweeperField>();
		total = analyze.getKnowledgeFor(field).getMineProbability();
		for (MinesweeperField finalField : finalFields) {
			for (MinesweeperField neighbor : finalField.getNeighbors()) {
				if (neighbor.isClicked()) continue;
				if (extras.contains(neighbor)) continue;
				extras.add(neighbor);
				total += analyze.getKnowledgeFor(neighbor).getMineProbability();
			}
		}
		
		
		// Fix for total < closestMineprobSum
		
//		return Math.abs(total - this.closestMineprobSum(analyze, field));
		
		return (-analyze.getKnowledgeFor(field).getMineProbability() * 2) + total - this.closestMineprobSum(analyze, field);
	}

}
