package net.zomis.minesweeper.analyze.utils;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Map.Entry;

import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.Solution;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class MineprobHelper {
	private static final double	PROB_100	= 0.999999;
	public static double nanoToMilli(long nano) {
		return nano / 1000000.0;
	}
	public static MinesweeperPlayingPlayer[] getOpponents(MinesweeperPlayingPlayer player) {
		List<MinesweeperPlayingPlayer> players = player.getMap().getPlayingPlayers();
		players.remove(player);
		return players.toArray(new MinesweeperPlayingPlayer[players.size()]);
	}
	
	
	public static Integer getCertainValue(ProbabilityKnowledge<MinesweeperField> data) {
		double[] probs = data.getProbabilities();
		for (int i = 0; i < probs.length; i++) {
			if (probs[i] == 1.0) {
				return i;
			}
		}
		
		return null;
	}
	
	public static double getMineProbabilityForField(MinesweeperField field) {
		MineprobabilityAnalyze analyze = new MineprobabilityAnalyze(field.getMap());
		AnalyzeResult<MinesweeperField> solve = analyze.solve();
		FieldGroup<MinesweeperField> group = solve.getGroupFor(field);
		
		if (group != null) {
			return group.getProbability();
		}
		else {
			return -1;
		}
	}
	public static <E> int find100(AnalyzeResult<E> analyze) {
		int i = 0;
		for (FieldGroup<E> grp : analyze.getGroups()) {
			if (grp.getProbability() > PROB_100) i += grp.size();
		}
		return i;
	}
	
	public static List<MinesweeperField> regenerate(MinesweeperMap map, AnalyzeResult<MinesweeperField> analyze, Random random) {
//		ZomisAnalyzeTest.testAnalyze(analyze, map);
		List<MinesweeperField> randomSolution = analyze.randomSolution(random);
		
		fixRemainingMines(map, randomSolution);
		
		return randomSolution;
	}
	public static int getFound(MinesweeperField field) {
		int i = 0;
		for (MinesweeperField ff : field.getNeighbors())
		if (ff.isDiscoveredMine()) i++;
		return i;
	}
	public static boolean isDraw(MinesweeperMap map) {
		if (map.getMinesLeft() != 1) return false;
		AnalyzeProvider analyze = AnalyzeFactory.analyze(map, false);
		Collection<Solution<MinesweeperField>> sols = analyze.getAnalyze().getSolutions();
		if (sols.size() != 1) return false;
		Solution<MinesweeperField> sol = sols.iterator().next();
		
		for (Entry<FieldGroup<MinesweeperField>, Integer> ee : sol.getSetGroupValues().entrySet()) {
			if (ee.getValue() == 0) continue;
			
			if (ee.getKey().size() != 2 || ee.getValue() != 1) return false;
		}
		return true;
	}
	public static void fixRemainingMines(MinesweeperMap map, List<MinesweeperField> remaining) {
		for (MinesweeperField ff : map.getIteration()) {
			if (!ff.isClicked()) { // support HiddenMaps by not caring whether or not the field is a mine. Just remove mines anyways.
				ff.setMine(false); // No need to check if map and analyze map is different here because we are using iteration of the correct map.
			}
		}
		for (MinesweeperField ff : remaining) {
			if (ff.getMap() != map) {
				ff = map.getPosition(ff);
//				throw new IllegalArgumentException("Analyze and map differs.");
			}
			ff.setMine(true);
		}
		map.initFields();
	}
}
