package net.zomis.minesweeper.analyze.impl;

import java.util.concurrent.TimeUnit;

import net.zomis.minesweeper.game.MinesweeperMap;

public class AnalyzeFactory {

	public static AnalyzeProvider analyze(MinesweeperMap map, boolean detailed, int timeout, TimeUnit timeUnit) {
		try {
			return new AnalyzeProvider(map, detailed, timeout, timeUnit);
		} catch (Exception e) { // TODO: Find a better exception type. Or create one.
			// Logger.getLogger(AnalyzeFactory.class).error("Analyze Timeout", e);
			return null;
//			throw e;
		}
	}
	
	public static AnalyzeProvider analyze(MinesweeperMap map, boolean detailed) {
		try {
			return new AnalyzeProvider(map, detailed, 30, TimeUnit.SECONDS);
		}
		catch (Exception e) {
			// Logger.getLogger(AnalyzeFactory.class).error("Analyze Timeout", e);
			return null;
		}
	}

}
