package net.zomis.mario.classes;

public class Point //: IEquatable<Point>
{
	public int row;
	public int col;
	public Point(int row, int col)
	{
		this.row = row;
		this.col = col;
	}
	public Point(UnknownPoint p)
	{
		this.row = p.row;
		this.col = p.col;
	}
	@Override
	public String toString()
	{
		return String.format("(%d,%d)", this.row, this.col);
	}

//	#region IEquatable<Point> Members
	@Override
	public boolean equals(Object other)
	{
		if (!(other instanceof Point)) return false;
		Point p = (Point) other;
		return (this.row == p.row && this.col == p.col);
	}

//	#endregion
}