/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin;

import java.util.ArrayList;
import java.util.List;
import net.zomis.minesweeper.ais.AI_Extreme3;
import net.zomis.minesweeper.ais.AI_Nightmare;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.ais.StaticAISupplier;
import net.zomis.minesweeper.ais.utils.AICompare;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.game.GameStartEvent;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.events.invites.InvitePreStartEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;
import net.zomis.minesweeper.weapons.classic.BombWeapon;
import net.zomis.minesweeper.weapons.classic.ClickWeapon;

public class WWAINDPlugin
extends MinesweeperPlugin
implements EventRegistrator {
    public static List<Class<? extends AI_Zomis>> getAIs() {
        ArrayList<Class<? extends AI_Zomis>> ais = new ArrayList<Class<? extends AI_Zomis>>();
        ais.add(AI_Nightmare.class);
        ais.add(AI_Extreme3.class);
        return ais;
    }

    public void onStart(GameStartEvent event) {
        this.createSituation(event.getGame());
    }

    public void onMove(PlayerMoveEvent event) {
        event.setCancelled(true);
        event.getGame().sendChatMessage("Move " + event.getMove() + " @ " + event.getGame().saveMap());
        this.createSituation(event.getGame());
    }

    public void onMove(InvitePreStartEvent event) {
        if (event.getInvite().getPlugins().contains((Object)this)) {
            event.getInvite().setAIDelay(false);
            event.getInvite().setPublic(Boolean.valueOf(true));
        }
    }

    @Command(command="wwaind", help="What would AI Nightmare do?")
    public void wwaind(PlayerCommandEvent event) {
        if (event.getGame() == null || !event.getGame().hasPlugin((MinesweeperPlugin)this)) {
            event.getPlayer().sendChat("/wwaind can only be used within a game using the " + this.getSimpleName() + " plugin.");
            return;
        }
        if (event.getGame().hasPlugin((MinesweeperPlugin)this)) {
            // empty if block
        }
    }

    private void createSituation(MinesweeperGame game) {
        game.sendChatMessage("Creating a situation...");
        MinesweeperMap map = game.getMapFactory().withTwoPlayers().withDefaultWeapons().loadFrom(game.saveMap()).map();
        for (MinesweeperPlayingPlayer pp : map.getPlayingPlayers()) {
            pp.giveWeapon((MinesweeperWeapon)new BombWeapon());
            pp.giveWeapon((MinesweeperWeapon)new ClickWeapon());
        }
        map.setCurrentPlayerTurn(game.getCurrentPlayer().getIndex());
        StaticAISupplier ai1 = new StaticAISupplier(new AI_Nightmare());
        StaticAISupplier ai2 = new StaticAISupplier(new AI_Extreme3());
        AICompare compare = new AICompare(map, ai1, ai2);
        compare.solveConflict();
        while (compare.compareNext() && !map.isGameOver()) {
        }
        game.loadMap(map.saveMap());
        MineprobHelper.regenerate((MinesweeperMap)game, AnalyzeFactory.analyze((MinesweeperMap)game, false).getAnalyze(), null);
        game.sendChatMessage("Situation Created!");
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    public boolean canBeChosenBy(MinesweeperPlayer user) {
        return user.hasPermission("TRUSTED");
    }

    public void registerEvents(EventRegister events) {
    }
}

