/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.game.GameStartEvent;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class OpenFieldChallenge
extends MinesweeperPlugin
implements EventRegistrator {
    private final double thinkProbability = 1.0;
    private List<MinesweeperField> needed100 = new ArrayList<MinesweeperField>();
    private MineprobabilityAnalyze analyze;

    public void getMineProbabilityOfMove(PlayerMoveEvent event) {
        if (event.getPlayer().getGame() == null) {
            return;
        }
        double chosen = MineprobHelper.getMineProbabilityForField(event.getMove().getMovePosition());
        if (Math.abs(chosen - 1.0) <= 1.0E-4) {
            this.needed100.remove(event.getMove().getMovePosition());
            event.getGame().sendChatMessage("MineprobChallenge: Well done! Remaining: " + this.needed100);
            if (this.needed100.isEmpty()) {
                this.startChallenge(event.getGame(), event.getMove().getMovePosition());
                if (!event.getMove().getMovePosition().isMine()) {
                    event.setCancelled(true);
                }
            }
        } else {
            event.getGame().sendChatMessage("MineprobChallenge: Sorry. I asked you to find a field with probability of " + this.thinkProbability + " but you found one with " + chosen);
            event.setCancelled(true);
            event.getMove().getMovePosition().sendInfoToPlayers();
        }
    }

    private void startChallenge(MinesweeperGame game, MinesweeperField ignore) {
        this.needed100.clear();
        int safety = 0;
        while (this.needed100.isEmpty()) {
            this.createSomethingRandom(game);
            this.analyze = new MineprobabilityAnalyze((MinesweeperMap)game);
            AnalyzeResult solution = this.analyze.solve();
            for (FieldGroup group : solution.getGroups()) {
                if (!(group.getProbability() >= 0.99999)) continue;
                this.needed100.addAll((Collection<MinesweeperField>)group);
            }
            if (ignore != null) {
                this.needed100.remove(ignore);
            }
            if (safety++ < 100) continue;
            break;
        }
        game.sendChatMessage("MineprobChallenge: I want you to click on " + this.needed100 + " fields with Mineprobability " + this.thinkProbability);
    }

    public void onChallengeStart(GameStartEvent event) {
        this.startChallenge(event.getGame(), null);
    }

    private void createSomethingRandom(MinesweeperGame game) {
        ((MinesweeperPlayingPlayer)game.getPlayingPlayers().get(0)).changeScore(1);
        MinesweeperMove move = game.getMapFactory().ai(game.getCurrentPlayer(), game.getServer().getAI("#AI_OpenField")).play(game.getCurrentPlayer());
        if (move != null && move.getWeapon() != null) {
            move.getWeapon().useAt(move);
        } else {
            game.sendChatMessage("Move could not be made: " + move);
        }
        if (move.getMovePosition().getValue() > 0 && !move.getMovePosition().isMine()) {
            game.generate();
            this.createSomethingRandom(game);
        } else if (move.getMovePosition().isMine()) {
            this.createSomethingRandom(game);
        }
        game.setCurrentPlayerTurn(0);
        for (MinesweeperPlayingPlayer pp : game.getPlayingPlayers()) {
            pp.changeScore(-pp.getScore());
        }
    }

    public boolean canBeChosenBy(MinesweeperPlayer player) {
        return player.hasPermission("ADMIN");
    }

    public void onDisable() {
    }

    public void onEnable() {
    }

    public void registerEvents(EventRegister events) {
        throw new UnsupportedOperationException();
    }
}

