/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.zomis.minesweeper.ais.AI_Nightmare;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.DefaultExpanderRule;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.game.GameInitEvent;
import net.zomis.minesweeper.events.game.GamePreGenerateEvent;
import net.zomis.minesweeper.events.game.PlayerAfterMoveEvent;
import net.zomis.minesweeper.events.game.PlayerEliminatedEvent;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class FeedbackPlugin
extends MinesweeperPlugin
implements EventRegistrator {
    private static String SENDER = FeedbackPlugin.class.getSimpleName();

    public void registerEvents(EventRegister events) {
        events.registerListener(PlayerEliminatedEvent.class, (Consumer)new Consumer<PlayerEliminatedEvent>(){

            public void accept(PlayerEliminatedEvent playerEliminatedEvent) {
                FeedbackPlugin.this.onPlayerEliminated(playerEliminatedEvent);
            }
        });
        events.registerListener(PlayerMoveEvent.class, (Consumer)new Consumer<PlayerMoveEvent>(){

            public void accept(PlayerMoveEvent playerMoveEvent) {
                FeedbackPlugin.this.onMove(playerMoveEvent);
            }
        });
        events.registerListener(PlayerAfterMoveEvent.class, (Consumer)new DefaultExpanderRule());
        events.registerListener(GamePreGenerateEvent.class, StandardNeighbors.classicNeighbors);
        events.registerListener(GameInitEvent.class, (Consumer)new StandardWeapons());
    }

    private FeedbackMeta getMeta(MinesweeperGame game) {
        FeedbackMeta meta = (FeedbackMeta)game.getMetadata().getClass(FeedbackMeta.class);
        if (meta == null) {
            return (FeedbackMeta)game.getMetadata().addClass((Object)new FeedbackMeta());
        }
        return meta;
    }

    public void onPlayerEliminated(PlayerEliminatedEvent event) {
        if (event.getGame() == null) {
            return;
        }
        event.getGame().sendChatMessage(SENDER, "Average for " + event.getPlayingPlayer() + ": " + this.getMeta(event.getGame()).calcAverage(event.getPlayingPlayer()));
    }

    public void onMove(PlayerMoveEvent event) {
        if (event.getServer() == null) {
            return;
        }
        new AsyncFeedback(event.getGame(), this.getAIZomis(event.getMap()), event.getMove()).run();
    }

    private AI_Zomis getAIZomis(MinesweeperMap game) {
        for (MinesweeperPlayingPlayer pp : game.getPlayingPlayers()) {
            if (!pp.isAI() || !(pp.getAI() instanceof AI_Zomis)) continue;
            return (AI_Zomis)pp.getAI();
        }
        return null;
    }

    @Command(command="feedback", help="Get some feedback", requiredPermission="TRUSTED")
    public void feedback(PlayerCommandEvent event) {
        MinesweeperPlayingPlayer pp = event.getMap().getCurrentPlayer();
        AI_Nightmare ai = new AI_Nightmare();
        MinesweeperWeapon weapon = pp.getWeapon("P");
        FieldScores scores = ai.createScoreProvider(pp).analyzeAndScore(weapon, false);
        MinesweeperField field = event.getMap().getPosition(event.getParameterInt(0, -1), event.getParameterInt(1, -1));
        ProbabilityKnowledge<MinesweeperField> data = scores.getAnalyze().getKnowledgeFor(field);
        event.getPlayer().sendChat("Checking field " + field);
        for (AbstractScorer scorer : ai.getConfig().getScorers().keySet()) {
            if (weapon.canUseAt(pp, field)) break;
            double score = scorer.getScoreFor(field, data, scores);
            if (score != 0.0) {
                event.getPlayer().sendChat(scorer.getName() + " gives " + score);
                continue;
            }
            event.getPlayer().sendChat(scorer.getName() + " score was zero");
        }
        event.getPlayer().sendChat("Done!");
    }

    public void onEnable() {
        this.registerListener((EventListener)new DefaultExpanderRule());
    }

    public void onDisable() {
    }

    public boolean canBeChosenBy(MinesweeperPlayer user) {
        return true;
    }

    private class AsyncFeedback
    implements Runnable {
        private MinesweeperGame game;
        private AI_Zomis zomis;
        private MinesweeperMove move;
        private MinesweeperMap map;

        public AsyncFeedback(MinesweeperGame game, AI_Zomis ai, MinesweeperMove move) {
            this.game = game;
            this.map = game;
            this.zomis = ai;
            this.move = move;
        }

        @Override
        public void run() {
            if (!this.move.getMoveAllowedState().isOK()) {
                this.game.sendChatMessage(FeedbackPlugin.this.getSimpleName(), "Move " + this.move + " not allowed", null);
                return;
            }
            MinesweeperPlayer player = this.game.getCurrentPlayer().getPlayer();
            if (this.zomis == null) {
                this.zomis = new AI_Nightmare();
            }
            this.game.sendChatMessage(player, "Performing.");
            MinesweeperPlayingPlayer pp = this.game.getCurrentPlayer();
            AI_Zomis ai = (AI_Zomis)this.map.getMapFactory().ai(this.map.getCurrentPlayer(), AI_Nightmare.PROVIDER);
            FieldScores scores = ai.createScoreProvider(pp).analyzeAndScore(this.move.getWeapon(), false);
            scores.rankScores();
            MinesweeperField fieldPlayed = this.move.getMovePosition();
            FieldScore score = scores.getScoreFor(fieldPlayed);
            int rank = score.getRank();
            int ranklength = scores.getRankCount();
            double normScore = scores.getNormalized(fieldPlayed);
            if (normScore == -2.0) {
                normScore = -1.0;
                this.game.sendChatMessage(player, "AI did not even thought about considering move " + this.move + ". Setting score for the move to -1.");
            }
            Integer color = null;
            color = normScore < 0.9 ? Integer.valueOf(0xFF8080) : Integer.valueOf(65280);
            this.game.sendChatMessage(SENDER, String.format("%s: %s (%d) used %s at %s. Score %f. Rank %d / %d.", this.zomis.getName(), this.move.getPlayer().getName(), this.move.getPlayer().getScore(), this.move.getWeapon(), this.move.getField(), normScore, rank, ranklength), color);
            FeedbackPlugin.this.getMeta(this.game).addMove(this.move.getPlayer(), normScore);
            this.sendFieldProbabilities(fieldPlayed, scores.getAnalyze().getKnowledgeFor(fieldPlayed));
        }

        private void sendFieldProbabilities(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data) {
            if (data == null) {
                return;
            }
            int min = -1;
            int max = 9;
            for (int i = 0; i < data.getProbabilities().length; ++i) {
                if (data.getProbabilities()[i] <= 0.0) continue;
                max = i;
                if (min != -1) continue;
                min = i;
            }
            this.game.sendChatMessage(SENDER, field + " had mine probability " + data.getMineProbability());
            if (min != -1) {
                this.game.sendChatMessage(SENDER, field + " had probability of " + min + ": " + data.getProbabilities()[min]);
            }
            if (max != 9) {
                this.game.sendChatMessage(SENDER, field + " had probability of " + max + ": " + data.getProbabilities()[max]);
            }
        }
    }

    private class FeedbackMeta {
        private Map<MinesweeperPlayingPlayer, List<Double>> list = new HashMap<MinesweeperPlayingPlayer, List<Double>>();

        private FeedbackMeta() {
        }

        private void addMove(MinesweeperPlayingPlayer player, Double score) {
            if (!this.list.containsKey(player)) {
                ArrayList l = new ArrayList();
                this.list.put(player, l);
            }
            this.list.get(player).add(score);
        }

        public double calcAverage(MinesweeperPlayingPlayer pp) {
            List<Double> list = this.list.get(pp);
            if (list == null) {
                return -2.147483648E9;
            }
            if (list.size() == 0) {
                return 0.0;
            }
            double total = 0.0;
            for (Double d : list) {
                total += d.doubleValue();
            }
            return total / (double)list.size();
        }
    }
}

