/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.otherscorers;

import java.util.List;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class ClosePlayToLastClick
extends AbstractScorer {
    private final double maxDistance;

    public ClosePlayToLastClick(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        return this.weaponIsClick(scores.getWeapon());
    }

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        MinesweeperMove move = ClosePlayToLastClick.getLastMove(scores.getPlayer().getMap());
        if (move == null) {
            return 0.0;
        }
        double dist = Math.max(Math.abs(field.getX() - move.getField().getX()), Math.abs(field.getY() - move.getField().getY()));
        if (dist >= this.maxDistance) {
            return -1.0;
        }
        return 0.0;
    }

    private static MinesweeperMove getLastMove(MinesweeperMap map) {
        List history = map.getMoveHistory();
        for (int i = history.size() - 1; i >= 0; --i) {
            MinesweeperMove move = (MinesweeperMove)history.get(i);
            if (move == null || move.getField() == null) continue;
            return move;
        }
        return null;
    }
}

