/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.mirror;

import java.util.ArrayList;
import java.util.List;
import net.zomis.minesweeper.ais.AIZomisSupplier;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.ais.StatUtils;
import net.zomis.minesweeper.ais.mirror.MirrorScorer;
import net.zomis.minesweeper.ais.test.AINormalizedScorer;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScoreProducer;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.scores.ScoreParameters;

public class MirrorScorerAI
extends MirrorScorer {
    private final MinesweeperPlayingPlayer player;
    private int count = 0;
    private int acceptable = 0;
    private final List<Double> normalized = new ArrayList<Double>();
    private final List<Integer> ranks = new ArrayList<Integer>();
    private final AI_Zomis ai;
    private AIZomisSupplier aiClass;
    private AINormalizedScorer scorer;
    private double lastNorm = 0.0;

    public MirrorScorerAI(MinesweeperPlayingPlayer player, AIZomisSupplier aiClass) {
        this.aiClass = aiClass;
        this.ai = aiClass.get(player);
        this.player = player;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        this.scorer = new AINormalizedScorer(this.aiClass);
        return this.scorer.workWithWeapon(scores);
    }

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        return this.scorer.getScoreFor(field, data, scores);
    }

    @Override
    public boolean moveInform(MinesweeperMove move, MinesweeperMap analyzeMap) {
        double norm;
        MinesweeperField newField = analyzeMap.getPosition(move.getField().getX(), move.getField().getY());
        MinesweeperPlayingPlayer pp = (MinesweeperPlayingPlayer)analyzeMap.getPlayingPlayers().get(this.player.getIndex());
        FieldScoreProducer fproduce = new FieldScoreProducer(pp, this.ai.getConfig());
        FieldScores scores = fproduce.analyzeAndScore(pp.getWeapon("P"), true);
        if (scores == null) {
            ++this.count;
            return false;
        }
        scores.rankScores();
        FieldScore score = scores.getScoreFor(newField);
        this.lastNorm = norm = scores.getNormalized(newField);
        this.normalized.add(norm);
        this.ranks.add(score.getRank());
        ++this.count;
        if (score.getRank() < 10 && norm >= 0.9) {
            ++this.acceptable;
        }
        if (score.getRank() >= scores.getRankCount() - 5 || norm < 0.2) {
            --this.acceptable;
        }
        if (this.acceptable < 0) {
            this.acceptable = 0;
        }
        return true;
    }

    public double getNormalizedAverage() {
        return StatUtils.mean(this.normalized);
    }

    public double getAcceptable() {
        return (double)this.acceptable / (double)this.count;
    }

    @Override
    public String toString() {
        return this.ai.getName() + ": Acceptable = " + this.getAcceptable() + ". Normalized = " + this.getNormalizedAverage() + " last norm = " + this.lastNorm;
    }

    @Override
    public double getPower() {
        if (this.lastNorm < 0.3) {
            return 0.0;
        }
        return this.lastNorm;
    }

    public AI_Zomis getAI() {
        return this.ai;
    }

    @Deprecated
    public AIZomisSupplier getAIClass() {
        return this.aiClass;
    }
}

