/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.mirror;

import java.util.ArrayList;
import java.util.Random;
import net.zomis.minesweeper.ais.StatUtils;
import net.zomis.minesweeper.ais.mirror.MirrorScorer;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.scores.ScoreParameters;

public class MirrorDontTakeAll100
extends MirrorScorer {
    private AnalyzeProvider rootAnalyze;
    private int failed100 = 0;
    private int taken100 = 0;
    private double avoid;
    private static Random random = new Random();

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        double threshold;
        this.rootAnalyze = AnalyzeFactory.analyze(scores.getPlayer().getMap(), false);
        double rand = random.nextDouble();
        this.avoid = rand <= (threshold = (double)this.failed100 / (double)(this.taken100 + this.failed100)) ? this.getAverage(this.rootAnalyze.getAnalyze()) : 100.0;
        return this.weaponIsClick(scores.getWeapon());
    }

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        if (this.failed100 + this.taken100 <= 0) {
            return 0.0;
        }
        FieldGroup group = this.rootAnalyze.getAnalyze().getGroupFor((Object)field);
        if (group == null) {
            return 0.0;
        }
        if (group.getProbability() > this.avoid) {
            return -1.5;
        }
        return 0.0;
    }

    private double getAverage(AnalyzeResult<MinesweeperField> analyze) {
        ArrayList<Double> probs = new ArrayList<Double>();
        for (FieldGroup ff : analyze.getGroups()) {
            double prob = ff.getProbability();
            if (!(prob > 0.0) || !(prob < 0.9999)) continue;
            probs.add(prob);
        }
        if (probs.isEmpty()) {
            probs.add(0.5);
        }
        return StatUtils.mean(probs);
    }

    @Override
    public boolean moveInform(MinesweeperMove move, MinesweeperMap map) {
        AnalyzeProvider analyze = AnalyzeFactory.analyze(map, false);
        int find100 = 0;
        MinesweeperField field = map.getPosition(move.getField());
        FieldGroup group = analyze.getAnalyze().getGroupFor((Object)field);
        if (group == null) {
            return true;
        }
        double average = this.getAverage(analyze.getAnalyze());
        find100 = 1;
        if (group.getProbability() >= average) {
            this.taken100 += find100;
        } else {
            this.failed100 += find100;
        }
        return true;
    }

    @Override
    public double getPower() {
        return 1.0;
    }

    @Override
    public String toString() {
        return "Failed " + this.failed100 + " Taken " + this.taken100;
    }
}

