/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.mirror;

import java.util.List;
import net.zomis.minesweeper.ais.AI_Complete_Idiot;
import net.zomis.minesweeper.ais.AI_Extreme3;
import net.zomis.minesweeper.ais.AI_HardPlus;
import net.zomis.minesweeper.ais.AI_Medium;
import net.zomis.minesweeper.ais.AI_ZLoser;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.ais.Disabled_AI_Horrible;
import net.zomis.minesweeper.ais.StaticAISupplier;
import net.zomis.minesweeper.ais.StaticAIZomisSupplier;
import net.zomis.minesweeper.ais.mirror.Analyze_AI_Mirror;
import net.zomis.minesweeper.ais.mirror.MirrorScorerAI;
import net.zomis.minesweeper.ais.mirror.MirrorScorerRating;
import net.zomis.minesweeper.analyze.endgame.PlayerUtils;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScoreProducer;
import net.zomis.minesweeper.scores.ScoreConfig;
import net.zomis.minesweeper.scores.ScoreProducer;

public class AI_Mirror
extends MinesweeperAI
implements ScoreProducer {
    private Analyze_AI_Mirror mirror;
    private final MinesweeperPlayingPlayer player;
    private int lastMove = 0;

    public AI_Mirror(MinesweeperPlayingPlayer player) {
        super("#AI_Mirror");
        this.player = player;
    }

    private void updateAnalyze(MinesweeperPlayingPlayer pp) {
        if (this.mirror == null) {
            this.mirror = AI_Mirror.newMirror(this.getOpponent(pp));
        }
        if (this.lastMove > pp.getMap().getMoveHistory().size()) {
            this.mirror = AI_Mirror.newMirror(this.getOpponent(pp));
            this.lastMove = 0;
        }
        List newMoves = pp.getMap().getMoveHistory().subList(this.lastMove, pp.getMap().getMoveHistory().size());
        for (MinesweeperMove move : newMoves) {
            if (move.getPlayer() == pp) continue;
            this.mirror.moveInform(move);
        }
        this.lastMove += newMoves.size();
    }

    private static Analyze_AI_Mirror newMirror(MinesweeperPlayingPlayer player) {
        Analyze_AI_Mirror mirr = new Analyze_AI_Mirror(player);
        mirr.addScorer(new MirrorScorerAI(player, new StaticAIZomisSupplier(new AI_Extreme3()))).addScorer(new MirrorScorerAI(player, new StaticAIZomisSupplier(new AI_HardPlus()))).addScorer(new MirrorScorerAI(player, new StaticAIZomisSupplier(new AI_Medium()))).addScorer(new MirrorScorerAI(player, new StaticAIZomisSupplier(new AI_ZLoser()))).addScorer(new MirrorScorerAI(player, new StaticAIZomisSupplier(new Disabled_AI_Horrible()))).addScorer(new MirrorScorerRating(mirr));
        return mirr;
    }

    private MinesweeperPlayingPlayer getOpponent(MinesweeperPlayingPlayer pp) {
        return PlayerUtils.getLastPlayer(pp);
    }

    @Override
    public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
        this.updateAnalyze(pp);
        if (this.mirror.getCount() <= 0) {
            return new AI_Complete_Idiot().play(pp);
        }
        this.sendChatMessage(pp, this.mirror.toString());
        AI_Zomis ai = new AI_Zomis(this.getName(), this.mirror.getScoreConfig()){};
        ai.setBackup(new StaticAISupplier(new AI_Complete_Idiot()));
        return ai.play(pp);
    }

    public boolean respondToInvite(Invite invite) {
        return true;
    }

    public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
        return MineprobHelper.isDraw(pp.getMap());
    }

    @Override
    public ScoreConfig getConfig() {
        this.updateAnalyze(this.player);
        return this.mirror.getScoreConfig();
    }

    @Override
    public FieldScoreProducer createScoreProvider(MinesweeperPlayingPlayer pp) {
        return new FieldScoreProducer(pp, this.getConfig());
    }
}

