/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.weapons.classic.BombWeapon;

public class NoZeroPercent_IfLead
extends AbstractScorer {
    private static final double THRESHOLD = 0.18;

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        boolean allBombsUsed = true;
        for (MinesweeperPlayingPlayer pp : scores.getPlayer().getMap().getPlayingPlayers()) {
            BombWeapon bw;
            if (pp == scores.getPlayer()) continue;
            if (pp.getScore() >= scores.getPlayer().getScore()) {
                return false;
            }
            if (!(pp.getWeapon("B") instanceof BombWeapon) || (bw = (BombWeapon)pp.getWeapon("B")).getUseCount() != 0) continue;
            allBombsUsed = false;
        }
        return this.weaponIsClick(scores.getWeapon()) && !allBombsUsed;
    }

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        if (data == null) {
            return 0.0;
        }
        if (data.getFieldGroup().getProbability() <= 0.18) {
            return -10000.0;
        }
        return 0.0;
    }
}

