/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.zomis.UtilZomisList;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.ai.AISupplier;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScoreProducer;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.scores.ScoreConfig;
import net.zomis.minesweeper.scores.ScoreProducer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public abstract class AI_Zomis
extends MinesweeperAI
implements ScoreProducer {
    private final ScoreConfig config;
    private AISupplier backup = null;
    private Map<MinesweeperWeapon, FieldScores> lastScores = new HashMap<MinesweeperWeapon, FieldScores>();

    @Override
    public ScoreConfig getConfig() {
        return this.config;
    }

    public AI_Zomis(String name, ScoreConfig config) {
        super(name);
        this.config = config;
    }

    @Deprecated
    public Map<MinesweeperWeapon, FieldScores> getLastScores() {
        return new HashMap<MinesweeperWeapon, FieldScores>(this.lastScores);
    }

    public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
        return MineprobHelper.isDraw(pp.getMap());
    }

    protected MinesweeperMove playWithDrawproposal(MinesweeperPlayingPlayer pp) {
        return this.internalplay(pp);
    }

    @Override
    public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
        return this.internalplay(pp);
    }

    private MinesweeperMove internalplay(MinesweeperPlayingPlayer pp) {
        HashMap<MinesweeperWeapon, List<FieldScore>> bestMoves = new HashMap<MinesweeperWeapon, List<FieldScore>>();
        if (pp.getWeapons().isEmpty()) {
            throw new IllegalStateException("No weapons for AI: " + pp);
        }
        long time = System.nanoTime();
        FieldScoreProducer scoreProvider = new FieldScoreProducer(pp, this.getConfig());
        if (!scoreProvider.analyze()) {
            String backupName = this.backup == null ? "null" : this.backup.toString();
            this.sendChatMessage(pp, "Map layout too complex. I ask my backup: " + backupName);
            if (this.backup == null) {
                this.sendChatMessage(pp, "I could not find my backup " + backupName + ". I'm screwed!");
            }
            return this.backup.get(pp).play(pp);
        }
        HashMap<MinesweeperMove, Double> moves = new HashMap<MinesweeperMove, Double>();
        this.lastScores.clear();
        for (MinesweeperWeapon weapon : pp.getWeapons()) {
            if (!weapon.canUse(pp)) continue;
            FieldScores scores = scoreProvider.score(weapon);
            this.lastScores.put(weapon, scores);
            if (scores == null) {
                return this.backup.get(pp).play(pp);
            }
            List<FieldScore> best = scores.getBestFields();
            bestMoves.put(weapon, best);
            if (best.isEmpty()) continue;
            FieldScore chosen = (FieldScore)UtilZomisList.getRandom(best);
            MinesweeperMove move = pp.createMove(weapon.getWeaponType(), chosen.getField());
            moves.put(move, chosen.getScore());
        }
        SortedSet sortedMoves = UtilZomisList.entriesSortedByValues(moves, (boolean)true);
        MinesweeperMove move = null;
        if (!sortedMoves.isEmpty()) {
            move = (MinesweeperMove)((Map.Entry)sortedMoves.iterator().next()).getKey();
        }
        time = System.nanoTime() - time;
        return move;
    }

    public boolean respondToInvite(Invite invite) {
        return true;
    }

    public void setBackup(AISupplier backup) {
        this.backup = backup;
    }

    @Override
    public FieldScoreProducer createScoreProvider(MinesweeperPlayingPlayer pp) {
        return new FieldScoreProducer(pp, this.getConfig());
    }
}

