/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.mfeais;

import net.zomis.mario.classes.Bot;
import net.zomis.mario.classes.Enums;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class NightmareTools {
    public static char[] unknownLine() {
        return "????????????????".toCharArray();
    }

    public static char[] oneLine() {
        return "??????????????3?".toCharArray();
    }

    public static char[][] megaClone(char[][] matrix) {
        char[][] cloned = new char[matrix.length][];
        for (int i = 0; i < matrix.length; ++i) {
            cloned[i] = (char[])matrix[i].clone();
        }
        return cloned;
    }

    public static char[][] testBoard() {
        return new char[][]{NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.oneLine(), NightmareTools.unknownLine()};
    }

    public static char[][] emptyBoard() {
        return new char[][]{NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine(), NightmareTools.unknownLine()};
    }

    public static int count(char[][] logicBoard, char c) {
        int i = 0;
        char[][] cArray = logicBoard;
        int n = cArray.length;
        for (int j = 0; j < n; ++j) {
            char[] ch;
            for (char cc : ch = cArray[j]) {
                if (cc != c) continue;
                ++i;
            }
        }
        return i;
    }

    public static char[][] fixBoard(MinesweeperPlayingPlayer player, Bot bot) {
        MinesweeperMap game = player.getMap();
        char[][] result = new char[game.getFieldWidth()][game.getFieldHeight()];
        for (MinesweeperField field : game.getIteration()) {
            char ch;
            result[field.getY()][field.getX()] = ch = NightmareTools.fixChar(player, bot, field);
        }
        return result;
    }

    public static char fixChar(MinesweeperPlayingPlayer player, Bot bot, MinesweeperField field) {
        if (!field.isClicked()) {
            return '?';
        }
        if (field.isDiscoveredMine()) {
            if (field.getWhoClicked() == null) {
                return 'm';
            }
            boolean isBlue = Enums.PlayerColor.BLUE.equals((Object)bot.getPlayerColor());
            if (field.getWhoClicked().getIndex() == player.getIndex()) {
                return isBlue ? (char)'b' : 'r';
            }
            return isBlue ? (char)'r' : 'b';
        }
        return (char)(48 + field.getKnownValue());
    }
}

