/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.mfeais;

import java.util.List;
import net.zomis.UtilZomisList;
import net.zomis.mario.classes.Board;
import net.zomis.mario.classes.Bot;
import net.zomis.mario.classes.Click;
import net.zomis.mario.classes.Enums;
import net.zomis.mario.classes.Point;
import net.zomis.mario.mfeais.NightmareTools;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public abstract class AbstractMarioBot
extends MinesweeperAI {
    public static boolean USE_RANDOMNESS = false;
    private final MinesweeperPlayingPlayer player;
    private Bot bot;

    public Bot getBot() {
        return this.bot;
    }

    public AbstractMarioBot(String name, MinesweeperPlayingPlayer player, Enums.Difficult difficulty) {
        super(name);
        this.player = player;
        this.bot = new Bot(player.getIndex() == 0 ? Enums.PlayerColor.BLUE : Enums.PlayerColor.RED, difficulty);
    }

    public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
        return false;
    }

    public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
        char[][] board = NightmareTools.fixBoard(pp, this.bot);
        try {
            List<Click> moves = this.bot.move(board);
            Click click = null;
            if (USE_RANDOMNESS) {
                click = (Click)UtilZomisList.getRandom(moves);
            } else {
                if (moves.isEmpty()) {
                    return null;
                }
                click = moves.get(0);
            }
            if (click == null) {
                MinesweeperField field = (MinesweeperField)UtilZomisList.getRandom((List)pp.getMap().getAllUnclickedFields());
                return pp.createMove("P", field);
            }
            this.sendClickInfo(click, this.bot.getBoard());
            return pp.createMove("P", pp.getMap().getPosition(click.col, click.row));
        }
        catch (Exception e) {
            this.sendChatMessage(pp, e.getClass().getCanonicalName() + ": " + e.getMessage());
            StackTraceElement[] stack = e.getStackTrace();
            for (int i = 0; i < stack.length && i < 20; ++i) {
                this.sendChatMessage(pp, stack[i].toString());
            }
            return null;
        }
    }

    private void sendClickInfo(Click click, Board board) {
    }

    public static void logBoards(MinesweeperPlayingPlayer pp, MinesweeperAI ai, char[][] board, MinesweeperGame game) {
        ai.sendChatMessage(pp, "The board I got was:");
        for (char[] ch : board) {
            ai.sendChatMessage(pp, new String(ch));
        }
        ai.sendChatMessage(pp, "While the real board is:");
        for (String str : pp.getMap().saveMapMultiline()) {
            ai.sendChatMessage(pp, str);
        }
    }

    public boolean respondToInvite(Invite invite) {
        return true;
    }

    public void respondTo(PlayerCommandEvent event) {
        if (event.getParameter(0).contentEquals("expval")) {
            int x = event.getParameterInt(1, 0);
            int y = event.getParameterInt(2, 0);
            this.sendChatMessage(this.player, String.format("First expected value of %s is %f", new Point(y, x), this.bot.getBoard().FirstExpectedValue()[y][x]));
        } else if (event.getParameter(0).contentEquals("square")) {
            int x = event.getParameterInt(1, 0);
            int y = event.getParameterInt(2, 0);
            this.sendChatMessage(this.player, this.bot.getBoard().square[y][x].toString());
        } else if (event.getParameter(0).contentEquals("maxexp")) {
            this.sendChatMessage(this.player, String.format("Max expected value is %f", this.bot.getBoard().MaxExpectedValue()));
        } else if (event.getParameter(0).contentEquals("max1exp")) {
            this.sendChatMessage(this.player, String.format("Max first expected value is %f", this.bot.getBoard().MaxFirstExpectedValue()));
        } else if (event.getParameter(0).contentEquals("minexp")) {
            this.sendChatMessage(this.player, String.format("Min expected value is %f", this.bot.getBoard().MinFirstExpectedValue()));
        } else if (event.getParameter(0).contentEquals("min1exp")) {
            this.sendChatMessage(this.player, String.format("Min first expected value is %f", this.bot.getBoard().MinFirstExpectedValue()));
        } else if (event.getParameter(0).contentEquals("tostr")) {
            this.sendChatMessage(this.player, this.bot.getBoard().toString());
        } else if (event.getParameter(0).contentEquals("analyze")) {
            char[][] board = NightmareTools.fixBoard(this.player, this.bot);
            this.sendChatMessage(this.player, "Analyzing on command.");
            for (Click click : this.bot.move(board)) {
                this.sendChatMessage(this.player, "I would make this move: " + click);
            }
        } else {
            this.sendChatMessage(this.player, "I don't know how to respond to that. Try with one of these: expval, square, maxexp, max1exp, minexp, min1exp, tostr, analyze");
        }
    }
}

