/*
 * Decompiled with CFR 0.152.
 */
package net.tejpbit.ais;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.tejpbit.ais.TejpbitAI_Hard;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.Minesweeper;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class AI_Loser
extends MinesweeperAI {
    public AI_Loser() {
        super("#AI_Loser");
    }

    public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
        return false;
    }

    public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
        MinesweeperField bombField;
        AnalyzeResult<MinesweeperField> gameAnalyze = AnalyzeFactory.analyze(pp.getMap(), false).getAnalyze();
        if (pp.canUseWeapon("B") && pp.getMap().getAllUnclickedFields().size() == pp.getMap().getMinesLeft() && (bombField = this.eredags(pp)) != null) {
            Minesweeper.getServer().log(String.format("(%d, %d)", bombField.getX(), bombField.getY()));
            return pp.createMove("B", bombField);
        }
        List groups = gameAnalyze.getGroups();
        ArrayList lowProbabilityFields = new ArrayList();
        double lowestProbability = 42.42;
        for (Object group : groups) {
            if (group.getProbability() < lowestProbability) {
                lowestProbability = group.getProbability();
                lowProbabilityFields.clear();
                lowProbabilityFields.addAll(group);
                continue;
            }
            if (group.getProbability() != lowestProbability) continue;
            lowProbabilityFields.addAll(group);
        }
        ArrayList lowProbabilityCleaner = new ArrayList(lowProbabilityFields);
        for (MinesweeperField checkAdjacents : lowProbabilityFields) {
            boolean hasMineAdjacent = false;
            for (MinesweeperField invertedAdjacents : checkAdjacents.getInvertedNeighbors()) {
                if (!invertedAdjacents.isMine() || !invertedAdjacents.isClicked()) continue;
                hasMineAdjacent = true;
            }
            if (hasMineAdjacent) continue;
            lowProbabilityCleaner.remove(checkAdjacents);
        }
        if (lowProbabilityCleaner.size() > 0) {
            lowProbabilityFields = lowProbabilityCleaner;
        }
        Random random = new Random();
        int clickIndex = random.nextInt(lowProbabilityFields.size());
        return pp.createMove("P", (MinesweeperField)lowProbabilityFields.get(clickIndex));
    }

    private MinesweeperField eredags(MinesweeperPlayingPlayer pp) {
        HashMap<MinesweeperField, Integer> bombableFields = new HashMap<MinesweeperField, Integer>();
        ArrayList fields = new ArrayList(pp.getMap().getAllFields());
        for (MinesweeperField field : fields) {
            if (field.getX() < 2 || field.getX() > pp.getMap().getFieldWidth() - 3 || field.getY() < 2 || field.getY() > pp.getMap().getFieldHeight() - 3) continue;
            int mines = 0;
            for (MinesweeperField bombAdjacent : TejpbitAI_Hard.getBombAdjacents(field)) {
                if (bombAdjacent.isClicked()) continue;
                ++mines;
            }
            bombableFields.put(field, mines);
        }
        ArrayList finalBombFields = new ArrayList();
        int lowestMineCount = 42;
        for (Map.Entry bombField : bombableFields.entrySet()) {
            if ((Integer)bombField.getValue() < lowestMineCount && (Integer)bombField.getValue() != 0) {
                finalBombFields.clear();
                lowestMineCount = (Integer)bombField.getValue();
                finalBombFields.add(bombField.getKey());
                continue;
            }
            if ((Integer)bombField.getValue() != lowestMineCount) continue;
            finalBombFields.add(bombField.getKey());
        }
        return (MinesweeperField)finalBombFields.get(new Random().nextInt(finalBombFields.size()));
    }

    public boolean respondToInvite(Invite invite) {
        return true;
    }
}

