/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin;

import java.util.ArrayList;
import java.util.List;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.ais.AI_Extreme3;
import net.zomis.minesweeper.ais.AI_Nightmare;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.ais.utils.AICompare;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.DefaultExpanderRule;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameStartEvent;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.events.invites.InvitePreStartEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;
import net.zomis.weapons.classic.BombWeapon;
import net.zomis.weapons.classic.ClickWeapon;

public class WWAINDPlugin
extends MinesweeperPlugin
implements EventListener {
    public static List<Class<? extends AI_Zomis>> getAIs() {
        ArrayList<Class<? extends AI_Zomis>> ais = new ArrayList<Class<? extends AI_Zomis>>();
        ais.add(AI_Nightmare.class);
        ais.add(AI_Extreme3.class);
        return ais;
    }

    @Event
    public void onStart(GameStartEvent event) {
        this.createSituation(event.getGame());
    }

    @Event
    public void onMove(PlayerMoveEvent event) {
        event.setCancelled(true);
        event.getGame().sendChatMessage("Move " + event.getMove() + " @ " + event.getGame().saveMap());
        this.createSituation(event.getGame());
    }

    @Event
    public void onMove(InvitePreStartEvent event) {
        if (event.getInvite().getPlugins().contains((Object)this)) {
            event.getInvite().setAIDelay(false);
            event.getInvite().setPublic(Boolean.valueOf(true));
        }
    }

    @Command(command="wwaind", help="What would AI Nightmare do?")
    public void wwaind(PlayerCommandEvent event) {
        if (event.getGame() == null || !event.getGame().hasPlugin((MinesweeperPlugin)this)) {
            event.getPlayer().sendChat("/wwaind can only be used within a game using the " + this.getSimpleName() + " plugin.");
            return;
        }
        if (event.getGame().hasPlugin((MinesweeperPlugin)this)) {
            for (Class<? extends AI_Zomis> clazz : WWAINDPlugin.getAIs()) {
                AI_Zomis ai = (AI_Zomis)event.getGame().getMapFactory().ai(event.getGame().getCurrentPlayer(), clazz);
                MinesweeperMove move = ai.play();
                List<FieldScore> list = ai.createScoreProvider().analyzeAndScore(move.getWeapon(), false).getBestFields();
                event.getPlayer().sendChat(ai.getClass().getSimpleName() + ": " + move + " with possible fields " + UtilZomisUtils.implode((String)", ", list));
            }
        }
    }

    private void createSituation(MinesweeperGame game) {
        game.sendChatMessage("Creating a situation...");
        MinesweeperMap map = game.getMapFactory().withTwoPlayers().withDefaultWeapons().loadFrom(game.saveMap()).map();
        for (MinesweeperPlayingPlayer pp : map.getPlayingPlayers()) {
            pp.giveWeapon((MinesweeperWeapon)new BombWeapon());
            pp.giveWeapon((MinesweeperWeapon)new ClickWeapon());
        }
        map.setCurrentPlayerTurn(game.getCurrentPlayer().getIndex());
        AICompare compare = new AICompare(map, AI_Nightmare.class, AI_Extreme3.class);
        compare.solveConflict();
        while (compare.compareNext() && !map.isGameOver()) {
        }
        game.loadMap(map.saveMap());
        MineprobHelper.regenerate((MinesweeperMap)game, AnalyzeFactory.analyze((MinesweeperMap)game, false).getAnalyze(), null);
        game.sendChatMessage("Situation Created!");
    }

    public void onEnable() {
        if (this.getServer() == null) {
            throw new NullPointerException("Server missing");
        }
        this.registerListener(this);
        this.registerListener((EventListener)new DefaultExpanderRule());
        this.registerListener((EventListener)new StandardNeighbors());
        this.registerListener((EventListener)new StandardWeapons());
    }

    public void onDisable() {
    }

    public boolean canBeChosenBy(MinesweeperPlayer user) {
        return user.hasPermission("TRUSTED");
    }
}

