/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.plugin;

import java.util.ArrayList;
import java.util.List;
import net.zomis.UtilZomisList;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.api.FieldType;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class AI_Complexer
extends MinesweeperAI {
    public AI_Complexer(MinesweeperPlayingPlayer player) {
        super(player);
        this.hide();
    }

    public boolean agreeDraw() {
        return false;
    }

    public MinesweeperMove play() {
        MineprobabilityAnalyze prob = new MineprobabilityAnalyze(this.getMap());
        AnalyzeResult solved = prob.solve();
        List rules = solved.getOriginalRules();
        ArrayList<MinesweeperField> potentials = new ArrayList<MinesweeperField>();
        for (RuleConstraint rule : rules) {
            if (rule.getCause() == null) continue;
            for (MinesweeperField neighbor : ((MinesweeperField)rule.getCause()).getNeighbors()) {
                FieldRule<MinesweeperField> newRule;
                if (neighbor.getFieldStyle() != FieldType.UNCLICKED || neighbor.isMine() || (newRule = prob.ruleFromField(neighbor)) == null || newRule.getResult() == 0 || newRule.getFieldsCountInGroups() == newRule.getResult()) continue;
                potentials.add(neighbor);
            }
        }
        if (!potentials.isEmpty()) {
            return this.getPlayingPlayer().createMove("P", (MinesweeperField)UtilZomisList.getRandom(potentials));
        }
        return this.playAs("#AI_Complete_Idiot");
    }

    public boolean respondToInvite(Invite invite) {
        return true;
    }
}

