/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.endgame;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.zomis.UtilZomisList;
import net.zomis.minesweeper.analyze.endgame.WinChanceData;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;
import net.zomis.weapons.classic.BombWeapon;
import net.zomis.weapons.classic.ClickWeapon;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class WinChanceAnalyze {
    private static final Logger logger = LogManager.getLogger(WinChanceAnalyze.class);
    private final Map<MinesweeperMove, WinChanceData> moves = new HashMap<MinesweeperMove, WinChanceData>();
    private final MinesweeperPlayingPlayer player;

    public MinesweeperMap getMap() {
        return this.player.getMap();
    }

    public WinChanceAnalyze(MinesweeperPlayingPlayer forPlayer) {
        this.player = forPlayer;
        this.analyze();
    }

    private void analyze() {
        List<MinesweeperMove> possibleMoves = this.calcPossibleMoves();
        AnalyzeProvider analyze = AnalyzeFactory.analyze(this.getMap(), true);
        for (MinesweeperMove move : possibleMoves) {
            this.moves.put(move, this.analyzeMove(move, analyze));
        }
    }

    private WinChanceData analyzeMove(MinesweeperMove move, AnalyzeProvider analyze) {
        WinChanceData data = new WinChanceData(move);
        if (move.getWeapon() instanceof BombWeapon) {
            data.analyzeBomb(analyze);
        }
        if (move.getWeapon() instanceof ClickWeapon) {
            data.analyzeClick(analyze);
        }
        return data;
    }

    private List<MinesweeperMove> calcPossibleMoves() {
        LinkedList<MinesweeperMove> list = new LinkedList<MinesweeperMove>();
        for (MinesweeperWeapon weap : this.player.getWeapons()) {
            if (!weap.canUse(this.player)) continue;
            for (MinesweeperField ff : this.getMap().getIteration()) {
                if (!weap.canUseAt(this.player, ff)) continue;
                list.add(this.player.createMove(weap, ff));
            }
        }
        logger.info((Object)("Possible moves: " + list.size()));
        return list;
    }

    public List<WinChanceData> getMoves() {
        SortedSet mm = UtilZomisList.entriesSortedByValues(this.moves, (boolean)true);
        ArrayList<WinChanceData> list = new ArrayList<WinChanceData>();
        for (Map.Entry ee : mm) {
            list.add((WinChanceData)ee.getValue());
        }
        return list;
    }

    public String toString() {
        return this.getMoves().toString();
    }
}

