/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class BadChickenPlayWhenBadProbabilities
extends AbstractScorer {
    public static boolean isBadProbabilities(AnalyzeResult<MinesweeperField> analyze) {
        double highestProb = 0.0;
        double prob = 0.0;
        for (FieldGroup ee : analyze.getGroups()) {
            if (ZomisTools.isZomisOpenField((MinesweeperField)ee.get(0))) {
                prob = ee.getProbability();
            }
            if (!(ee.getProbability() > highestProb)) continue;
            highestProb = ee.getProbability();
        }
        return highestProb <= prob;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        if (!this.weaponIsClick(scores.getWeapon())) {
            return false;
        }
        return BadChickenPlayWhenBadProbabilities.isBadProbabilities(scores.getAnalyze().getAnalyze());
    }

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        FieldGroup grp = scores.getAnalyze().getAnalyze().getGroupFor((Object)field);
        if (grp.getProbability() < 1.0E-6) {
            for (MinesweeperField ff : field.getInvertedNeighbors()) {
                if (!ff.isDiscoveredMine()) continue;
                return 1.0;
            }
        }
        return 0.0;
    }
}

