/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.zomis.UtilZomisList;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScoreProducer;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.scores.ScoreConfig;
import net.zomis.minesweeper.scores.ScoreProducer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public abstract class AI_Zomis
extends MinesweeperAI
implements ScoreProducer {
    private final ScoreConfig config;
    private Class<? extends MinesweeperAI> backup = null;
    private Map<MinesweeperWeapon, FieldScores> lastScores = new HashMap<MinesweeperWeapon, FieldScores>();

    @Override
    public ScoreConfig getConfig() {
        return this.config;
    }

    public AI_Zomis(MinesweeperPlayingPlayer player, ScoreConfig config) {
        super(player);
        this.config = config;
    }

    @Deprecated
    public Map<MinesweeperWeapon, FieldScores> getLastScores() {
        return new HashMap<MinesweeperWeapon, FieldScores>(this.lastScores);
    }

    public boolean agreeDraw() {
        return MineprobHelper.isDraw(this.getMap());
    }

    protected MinesweeperMove playWithDrawproposal() {
        if (this.agreeDraw() && this.getPlayingPlayer().proposeDraw()) {
            this.sendChatMessage("I propose draw! You've got 10 seconds to agree or not");
            if (!this.getPlayingPlayer().isEliminated()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.getPlayingPlayer().isEliminated()) {
                this.sendChatMessage("10 seconds has passed, now I make my move.");
            }
        }
        return this.internalplay();
    }

    @Override
    public MinesweeperMove play() {
        return this.internalplay();
    }

    private MinesweeperMove internalplay() {
        HashMap<MinesweeperWeapon, List<FieldScore>> bestMoves = new HashMap<MinesweeperWeapon, List<FieldScore>>();
        if (this.getPlayingPlayer().getWeapons().isEmpty()) {
            throw new IllegalStateException("No weapons for AI: " + this.getPlayingPlayer());
        }
        long time = System.nanoTime();
        FieldScoreProducer scoreProvider = new FieldScoreProducer(this.getPlayingPlayer(), this.getConfig());
        if (!scoreProvider.analyze()) {
            String backupName = this.backup == null ? "null" : this.backup.getSimpleName();
            this.sendChatMessage("Map layout too complex. I ask my backup: " + backupName);
            if (this.backup == null) {
                this.sendChatMessage("I could not find my backup " + backupName + ". I'm screwed!");
            }
            return this.playAs(this.backup);
        }
        HashMap<MinesweeperMove, Double> moves = new HashMap<MinesweeperMove, Double>();
        this.lastScores.clear();
        for (MinesweeperWeapon weapon : this.getPlayingPlayer().getWeapons()) {
            if (!weapon.canUse(this.getPlayingPlayer())) continue;
            FieldScores scores = scoreProvider.score(weapon);
            this.lastScores.put(weapon, scores);
            if (scores == null) {
                return this.playAs(this.backup);
            }
            List<FieldScore> best = scores.getBestFields();
            bestMoves.put(weapon, best);
            if (best.isEmpty()) continue;
            FieldScore chosen = (FieldScore)UtilZomisList.getRandom(best);
            MinesweeperMove move = this.getPlayingPlayer().createMove(weapon.getWeaponType(), chosen.getField());
            moves.put(move, chosen.getScore());
        }
        SortedSet sortedMoves = UtilZomisList.entriesSortedByValues(moves, (boolean)true);
        MinesweeperMove move = null;
        if (!sortedMoves.isEmpty()) {
            move = (MinesweeperMove)((Map.Entry)sortedMoves.iterator().next()).getKey();
        }
        time = System.nanoTime() - time;
        return move;
    }

    public boolean respondToInvite(Invite invite) {
        return true;
    }

    public void setBackup(Class<? extends MinesweeperAI> backup) {
        this.backup = backup;
    }

    @Override
    public FieldScoreProducer createScoreProvider() {
        return new FieldScoreProducer(this.getPlayingPlayer(), this.getConfig());
    }

    public static boolean hostIsWithinXRatingOfAI(Invite invite, MinesweeperAI ai, int ratingRange) {
        if (ai.getPlayer() == null) {
            return true;
        }
        if (ai.getPlayer().getRating() == null) {
            return true;
        }
        return AI_Zomis.hostHasMoreRating(invite, ai, Math.floor(ai.getPlayer().getRating() - (double)ratingRange));
    }

    public static boolean hostHasMoreRating(Invite invite, MinesweeperAI ai, double minRating) {
        if (invite == null) {
            return true;
        }
        if (invite.getHost() == null) {
            return true;
        }
        if (invite.getHost().getServer() != null && !ai.getPlayer().getServer().hasDatabaseConnection()) {
            return true;
        }
        if (invite.getHost().hasPermission("DONATOR")) {
            return true;
        }
        if (invite.getHost().getRating() != null && invite.getHost().getRating() < minRating) {
            invite.getHost().sendAlert(ai.getName() + ": Your rating is too low to play against me.\nPlease improve your rating to at least " + minRating);
            return false;
        }
        return true;
    }
}

