/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.analyze.endgame;

import java.util.Arrays;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.endgame.WinChanceTools;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.model.MapUtils;

public class WinChanceData
implements Comparable<WinChanceData> {
    private final MinesweeperMove move;
    private double instantLoss = 0.0;
    private double instantWin = 0.0;

    public WinChanceData(MinesweeperMove move) {
        this.move = move;
    }

    public void analyzeBomb(AnalyzeProvider analyze) {
    }

    public void analyzeClick(AnalyzeProvider analyze) {
        ProbabilityKnowledge<MinesweeperField> data = analyze.getKnowledgeFor(this.move.getField());
        double[] probs = data.getProbabilities();
        for (int i = 0; i < probs.length; ++i) {
            if (!(probs[i] > 0.0)) continue;
            this.testWithValues(probs[i], this.move.getField(), false, i, analyze.getAnalyze());
        }
        if (data.getMineProbability() > 0.0) {
            this.testWithValues(data.getMineProbability(), this.move.getField(), true, 0, analyze.getAnalyze());
        }
    }

    private MinesweeperMap testWithValues(double probability, MinesweeperField field, boolean isMine, int value, AnalyzeResult<MinesweeperField> rootAnalyze) {
        MinesweeperMap map = MapUtils.copyMap((MinesweeperMap)field.getMap());
        UtilZomisUtils.echo((Object)("testWithValues " + probability + " " + field + " is " + isMine + " val " + value));
        this.testAnalyze(rootAnalyze);
        AnalyzeResult analyze = !isMine ? rootAnalyze.cloneAddSolve(Arrays.asList(MineprobabilityAnalyze.ruleForField(field, false), MineprobabilityAnalyze.ruleFromField(field, value - ZomisTools.fieldFoundMines(field)))) : rootAnalyze.cloneAddSolve(Arrays.asList(MineprobabilityAnalyze.ruleForField(field, true)));
        this.testAnalyze((AnalyzeResult<MinesweeperField>)analyze);
        MineprobHelper.regenerate(map, (AnalyzeResult<MinesweeperField>)analyze, null);
        if (!isMine && value == 0) {
            for (double combo = 0.0; combo < analyze.getTotal(); combo += 1.0) {
                MinesweeperMap copy = MapUtils.copyBase((MinesweeperMap)map).loadMap(field.getMap().saveMap());
                MineprobHelper.fixRemainingMines(copy, analyze.getSolution(combo));
                MinesweeperMove newmove = this.moveToMap(copy);
                copy.performMove(newmove);
                this.checkForEnding(probability * 1.0 / analyze.getTotal(), copy, AnalyzeFactory.analyze(copy, false).getAnalyze());
            }
        } else {
            MinesweeperMove newmove = this.moveToMap(map);
            map.performMove(newmove);
            this.checkForEnding(probability, map, (AnalyzeResult<MinesweeperField>)analyze);
        }
        return map;
    }

    private MinesweeperMove moveToMap(MinesweeperMap map) {
        MinesweeperPlayingPlayer player = (MinesweeperPlayingPlayer)map.getPlayingPlayers().get(this.move.getPlayer().getIndex());
        return map.createMove(player, player.getWeapon(this.move.getWeaponType()), map.getPosition(this.move.getField()));
    }

    private void testAnalyze(AnalyzeResult<MinesweeperField> analyze) {
        MinesweeperMap map = null;
        for (FieldGroup fg : analyze.getGroups()) {
            for (MinesweeperField ff : fg) {
                if (map == null) {
                    map = ff.getMap();
                }
                if (map != ff.getMap()) {
                    throw new AssertionError((Object)("different maps: " + ff + " in group " + fg));
                }
            }
        }
    }

    private void checkForEnding(double probability, MinesweeperMap map, AnalyzeResult<MinesweeperField> analyze) {
        WinChanceTools.WinResult ending = WinChanceTools.checkDirectEnding((MinesweeperPlayingPlayer)map.getPlayingPlayers().get(this.move.getPlayer().getIndex()), analyze);
        if (ending == null) {
            return;
        }
        if (ending == WinChanceTools.WinResult.DRAW) {
            UtilZomisUtils.echo((Object)(this.move.getMoveString() + " DRAW with prob " + probability));
            this.instantLoss += probability / 2.0;
            this.instantWin += probability / 2.0;
        }
        if (ending == WinChanceTools.WinResult.LOSS) {
            UtilZomisUtils.echo((Object)(this.move.getMoveString() + " LOSS with prob " + probability));
            this.instantLoss += probability;
        }
        if (ending == WinChanceTools.WinResult.WIN) {
            UtilZomisUtils.echo((Object)(this.move.getMoveString() + "  WIN with prob " + probability));
            this.instantWin += probability;
        }
    }

    public double getWinExpected() {
        return this.instantWin - this.instantLoss;
    }

    public String toString() {
        return this.move.getMoveString() + ": " + this.getWinExpected();
    }

    @Override
    public int compareTo(WinChanceData o) {
        return (int)(1000.0 * (this.getWinExpected() - o.getWinExpected()));
    }
}

