/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.aiscore.mario;

import net.zomis.mario.classes.Square;
import net.zomis.minesweeper.ais.MarioAnalyze;
import net.zomis.minesweeper.aiscore.mario.MarioTools;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class RealMarioEVScorer
extends AbstractScorer {
    private MarioAnalyze mario;

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        Square square = this.mario.getSquare(field);
        if (MarioTools.isMarioOpenField(square)) {
            return 0.0;
        }
        if (data.getProbabilities()[0] == 1.0) {
            return 0.0;
        }
        if (!this.marioGivesInfo(square)) {
            return data.getMineProbability();
        }
        double expectedValue = data.getMineProbability() * (square.payoff[9] + square.expectedValues[9]);
        double[] probability = data.getProbabilities();
        for (int k = 0; k < probability.length; ++k) {
            double evk = square.expectedValues[k];
            if (evk > 0.1) {
                evk -= 0.01;
            }
            expectedValue -= probability[k] * (square.payoff[k] + evk);
        }
        if (this.mario.getBot().getBoard().MaxExpectedValue() < 0.0) {
            return 0.1 * expectedValue;
        }
        return expectedValue * 1.8;
    }

    private boolean marioGivesInfo(Square square) {
        return square.firstExpectedValue != null || square.expectedValue != null;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        this.mario = scores.getAnalyze(MarioAnalyze.class);
        return this.weaponIsClick(scores.getWeapon());
    }
}

