/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.aiscore;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.OpenFieldApproxer;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class OpenFieldsPenalty
extends AbstractScorer {
    private OpenFieldApproxer openField = new OpenFieldApproxer();

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        if (this.isInterestingField(field, data, scores.getWeapon())) {
            double expected = this.openField.expectedFrom(scores.getAnalyze(), field);
            double probability = data.getProbabilities()[0] * 7.0;
            double factor = 1.0;
            return -(expected * probability * factor);
        }
        return 0.0;
    }

    public boolean isInterestingField(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, MinesweeperWeapon weapon) {
        return data.getProbabilities()[0] > 0.0;
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        return this.weaponIsClick(scores.getWeapon());
    }
}

