/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.model.GameReplay;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScores;
import org.apache.commons.math3.stat.StatUtils;

@Deprecated
public class SkillRate {
    private GameReplay replay;
    private Class<? extends AI_Zomis> aiClass;
    private Map<MinesweeperMove, FieldScore> results;

    public SkillRate(GameReplay replay, Class<? extends AI_Zomis> aiClass) {
        this.replay = replay;
        this.aiClass = aiClass;
    }

    private AI_Zomis getAI() {
        try {
            return this.aiClass.getConstructor(MinesweeperPlayingPlayer.class).newInstance(this.replay.getMap().getCurrentPlayer());
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        throw new RuntimeException();
    }

    public Map<MinesweeperMove, FieldScore> getResults() {
        this.replay.setPosition(0);
        HashMap<MinesweeperMove, FieldScore> map = new HashMap<MinesweeperMove, FieldScore>();
        List moves = this.replay.getMoves();
        while (this.replay.getPosition() < this.replay.getMoveCount()) {
            MinesweeperMove move = (MinesweeperMove)moves.get(this.replay.getPosition());
            AI_Zomis ai = this.getAI();
            if (!ai.getPlayingPlayer().canUseWeapon(move.getWeaponType())) {
                throw new AssertionError((Object)("Replay error. Can't use weapon " + move + " at " + this.replay.getPosition()));
            }
            FieldScores scores = ai.createScoreProvider().analyzeAndScore(move.getWeapon(), false);
            if (scores == null) {
                throw new NullPointerException("Scores is null for " + move + " at replay position " + this.replay.getPosition());
            }
            scores.rankScores();
            FieldScore data = scores.getScoreFor(ai.getMap().getPosition(move.getMovePosition().getX(), move.getMovePosition().getY()));
            map.put(move, data);
            this.replay.nextMove();
        }
        this.results = map;
        return map;
    }

    public List<MinesweeperMove> getMovesBy(MinesweeperPlayingPlayer player) {
        ArrayList<MinesweeperMove> list = new ArrayList<MinesweeperMove>();
        for (MinesweeperMove move : this.replay.getMoves()) {
            if (!move.getPlayer().equals(player)) continue;
            list.add(move);
        }
        return list;
    }

    public double[] getNormalized(MinesweeperPlayingPlayer player) {
        if (this.results == null) {
            throw new IllegalStateException();
        }
        List<MinesweeperMove> moves = this.getMovesBy(player);
        int index = 0;
        double[] result = new double[moves.size()];
        for (int i = 0; i < result.length; ++i) {
            MinesweeperMove move = moves.get(i);
            FieldScore data = this.results.get(move);
            if (data == null) continue;
            result[index] = data.getNormalized();
            ++index;
        }
        return Arrays.copyOf(result, index + 1);
    }

    public double getAverage(MinesweeperPlayingPlayer player) {
        return StatUtils.mean((double[])this.getNormalized(player));
    }
}

