/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.ais.BadChickenPlayWhenBadProbabilities;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class HighestMineProbability
extends AbstractScorer {
    private double highestProb;

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        if (!this.weaponIsClick(scores.getWeapon())) {
            return false;
        }
        this.highestProb = 0.0;
        for (FieldGroup ee : scores.getAnalyze().getAnalyze().getGroups()) {
            if (!(ee.getProbability() > this.highestProb)) continue;
            this.highestProb = ee.getProbability();
        }
        return !BadChickenPlayWhenBadProbabilities.isBadProbabilities(scores.getAnalyze().getAnalyze());
    }

    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        FieldGroup grp = scores.getAnalyze().getAnalyze().getGroupFor((Object)field);
        if (grp == null) {
            return 0.0;
        }
        if (grp.getProbability() == this.highestProb) {
            return 1.0;
        }
        return 0.0;
    }
}

