/*
 * Decompiled with CFR 0.152.
 */
package net.tejpbit.ais;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.zomis.minesweeper.ais.AI_Complete_Idiot;
import net.zomis.minesweeper.api.AI;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

@AI(rating=-500.0)
public class AI_Challenger
extends MinesweeperAI {
    public AI_Challenger(MinesweeperPlayingPlayer player) {
        super(player);
    }

    public boolean agreeDraw() {
        return false;
    }

    public MinesweeperMove play() {
        HashSet<MinesweeperField> notMine = new HashSet<MinesweeperField>();
        ArrayList<MinesweeperField> possibleMine = new ArrayList<MinesweeperField>();
        for (MinesweeperField field : this.getMap().getIteration()) {
            if (!field.isClicked() || field.isMine() || field.isBlocked() || this.getFoundAdjacentMines(field) != field.getValue()) continue;
            for (MinesweeperField neighbor : field.getNeighbors()) {
                if (neighbor.isClicked()) continue;
                notMine.add(neighbor);
            }
        }
        for (MinesweeperField field : this.getMap().getIteration()) {
            if (!field.isClicked() || field.isMine() || field.isBlocked()) continue;
            int possibleMineCount = 0;
            for (MinesweeperField neighbor : field.getNeighbors()) {
                if (neighbor.isClicked() || notMine.contains(neighbor)) continue;
                ++possibleMineCount;
            }
            if (this.getFoundAdjacentMines(field) + possibleMineCount == field.getValue()) {
                for (MinesweeperField neighbor : field.getNeighbors()) {
                    if (neighbor.isClicked() || notMine.contains(neighbor)) continue;
                    return this.getPlayingPlayer().createMove("P", neighbor);
                }
                continue;
            }
            if (this.getFoundAdjacentMines(field) >= field.getValue()) continue;
            for (MinesweeperField neighbor : field.getNeighbors()) {
                if (neighbor.isClicked() || notMine.contains(neighbor) || possibleMine.contains(neighbor)) continue;
                possibleMine.add(neighbor);
            }
        }
        if (possibleMine.size() < 10 && this.ereDags()) {
            return this.getPlayingPlayer().createMove("B", AI_Challenger.getAIBombPos(this.getMap()));
        }
        if (possibleMine.size() > 0) {
            Random random = new Random();
            int randInt = random.nextInt(possibleMine.size());
            return this.getPlayingPlayer().createMove("P", (MinesweeperField)possibleMine.get(randInt));
        }
        if (this.ereDags()) {
            return this.getPlayingPlayer().createMove("B", AI_Challenger.getAIBombPos(this.getMap()));
        }
        return this.playAs(AI_Complete_Idiot.class);
    }

    private int getFoundAdjacentMines(MinesweeperField field) {
        int mineCount = 0;
        for (MinesweeperField neighbor : field.getNeighbors()) {
            if (!neighbor.isClicked() || !neighbor.isMine()) continue;
            ++mineCount;
        }
        return mineCount;
    }

    private boolean ereDags() {
        Random random = new Random();
        if (this.getMap().getCurrentPlayer().canUseWeapon("B") && random.nextInt(100) < 42) {
            int avarage = 0;
            for (int i = 0; i < this.getMap().getPlayingPlayers().size(); ++i) {
                avarage += ((MinesweeperPlayingPlayer)this.getMap().getPlayingPlayers().get(i)).getScore();
            }
            if (this.getMap().getCurrentPlayer().getScore() < (avarage /= this.getMap().getPlayingPlayers().size()) - (random.nextInt(3) + 2)) {
                return true;
            }
            if ((double)AI_Challenger.getHighestScore(this.getMap()) >= (double)this.getMap().getMinesCount() * 0.4) {
                return true;
            }
        }
        return false;
    }

    public boolean respondToInvite(Invite invite) {
        return true;
    }

    static int getHighestScore(MinesweeperMap game) {
        for (MinesweeperPlayingPlayer player : game.getPlayingPlayers()) {
            if (!player.hasMostScore()) continue;
            return player.getScore();
        }
        return 42;
    }

    public static MinesweeperField getAIBombPos(MinesweeperMap game) {
        ArrayList<MinesweeperField> bombable = new ArrayList<MinesweeperField>();
        int maxPossibleBombClick = 0;
        for (MinesweeperField gamePosition : game.getIteration()) {
            int unClickedPosCurrentBomb = 0;
            for (int y = -2; y <= 2; ++y) {
                for (int x = -2; x <= 2; ++x) {
                    if (game.getPosition(gamePosition.getX() + x, gamePosition.getY() + y) == null || game.getPosition(gamePosition.getX() + x, gamePosition.getY() + y).isClicked()) continue;
                    ++unClickedPosCurrentBomb;
                }
            }
            if (maxPossibleBombClick < unClickedPosCurrentBomb) {
                bombable.clear();
                bombable.add(gamePosition);
            } else if (maxPossibleBombClick == unClickedPosCurrentBomb) {
                bombable.add(gamePosition);
            }
            maxPossibleBombClick = Math.max(maxPossibleBombClick, unClickedPosCurrentBomb);
        }
        Random random = new Random();
        return (MinesweeperField)bombable.get(random.nextInt(bombable.size()));
    }
}

