/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.scores;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.PostScorer;
import net.zomis.minesweeper.scores.PreScorer;
import net.zomis.minesweeper.scores.ScoreConfig;
import net.zomis.minesweeper.scores.ScoreSet;

public class ScoreConfigFactory {
    private final AnalyzeMethod analyzeMethod;
    private ScoreSet scoreSet;
    private final List<PostScorer> postScorers;
    private final List<PreScorer> preScorers;

    public ScoreConfigFactory(AnalyzeMethod analyzeMethod) {
        this.analyzeMethod = analyzeMethod;
        this.scoreSet = new ScoreSet();
        this.postScorers = new LinkedList<PostScorer>();
        this.preScorers = new LinkedList<PreScorer>();
    }

    public ScoreConfigFactory withScorer(AbstractScorer scorer) {
        this.scoreSet.put(scorer, 1.0);
        return this;
    }

    public ScoreConfigFactory withScorer(AbstractScorer scorer, double weight) {
        this.scoreSet.put(scorer, weight);
        return this;
    }

    public ScoreConfigFactory multiplyAll(double value) {
        ScoreSet oldScoreSet = this.scoreSet;
        this.scoreSet = new ScoreSet();
        for (Map.Entry ee : oldScoreSet.entrySet()) {
            this.scoreSet.put(ee.getKey(), (Double)ee.getValue() * value);
        }
        return this;
    }

    public ScoreConfigFactory withPost(PostScorer post) {
        this.postScorers.add(post);
        return this;
    }

    public ScoreConfig build() {
        return new ScoreConfig(this.analyzeMethod, this.preScorers, this.postScorers, this.scoreSet);
    }

    public <E> ScoreConfigFactory withPreScorer(PreScorer analyzer) {
        this.preScorers.add(analyzer);
        return this;
    }
}

