/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.scores;

import java.util.HashMap;
import java.util.Map;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.scores.PreScorer;
import net.zomis.minesweeper.scores.ScoreConfig;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class FieldScoreProducer {
    private final MinesweeperPlayingPlayer player;
    private final ScoreConfig config;
    @Deprecated
    private AnalyzeProvider analyze;
    private final Map<Class<?>, Object> analyzes;
    private boolean analyzed;

    public FieldScoreProducer(MinesweeperPlayingPlayer player, ScoreConfig config) {
        this.player = player;
        this.config = config;
        this.analyzes = new HashMap();
        this.analyzed = false;
    }

    public FieldScores score(MinesweeperWeapon weapon) {
        if (!weapon.canUse(this.player)) {
            throw new IllegalStateException();
        }
        if (!this.analyzed) {
            return null;
        }
        FieldScores scores = new FieldScores(this.player, weapon, this.config);
        scores.setAnalyze(this.analyze);
        scores.setAnalyzes(this.analyzes);
        scores.determineActiveScorers();
        scores.calculateMoveScores();
        scores.calculateRankings();
        scores.postHandle();
        return scores;
    }

    public boolean analyze() {
        this.analyzed = false;
        for (PreScorer preScorers : this.config.getPreScorers()) {
            Object data = preScorers.analyze(this.getPlayer());
            if (data == null) {
                return false;
            }
            this.analyzes.put(data.getClass(), data);
        }
        if (this.config.getAnalyzeMethod().isZomisBasic()) {
            this.analyze = AnalyzeFactory.analyze(this.player.getMap(), this.config.getAnalyzeMethod().isZomisAdvanced());
            if (this.analyze == null) {
                return false;
            }
        }
        this.analyzed = true;
        return true;
    }

    public MinesweeperPlayingPlayer getPlayer() {
        return this.player;
    }

    public ScoreConfig getConfig() {
        return this.config;
    }

    public AnalyzeProvider getAnalyze() {
        return this.analyze;
    }

    public FieldScores analyzeAndScore(MinesweeperWeapon weapon, boolean detailed) {
        if (!this.analyze()) {
            return null;
        }
        return this.score(weapon);
    }
}

