/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.aiscore.debug;

import java.util.Collection;
import net.zomis.minesweeper.ais.BombTools;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class BombDebugScore
extends AbstractScorer {
    @Override
    public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
        MinesweeperPlayingPlayer player = scores.getPlayer();
        Collection affected = scores.getPlayer().getWeapon("B").getFieldsAffected(player, field);
        if (affected.isEmpty()) {
            return -10000.0;
        }
        return BombTools.getBombProbability(affected, scores.getAnalyze().getAnalyze());
    }

    @Override
    public boolean workWithWeapon(ScoreParameters scores) {
        return true;
    }
}

