/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.ais.utils.OpenField;
import net.zomis.minesweeper.aiscore.AvoidReveal50;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.analyze.utils.OpenFieldApproxer;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.scores.AbstractScorer;

public class ChickenAnalyze {
    private final AnalyzeProvider analyze;
    private final List<OpenField> openFields;
    private int extraSafe = 0;
    private final Set<MinesweeperField> unsafeReveal;
    private final Set<MinesweeperField> unsafe;

    public int getSafeCount() {
        return this.extraSafe;
    }

    public int getUnsafeCount() {
        return this.unsafe.size();
    }

    public Set<MinesweeperField> getUnsafe() {
        return new HashSet<MinesweeperField>(this.unsafe);
    }

    public List<OpenField> getOpenFields() {
        return new ArrayList<OpenField>(this.openFields);
    }

    public Set<MinesweeperField> getUnsafeReveal() {
        return new HashSet<MinesweeperField>(this.unsafeReveal);
    }

    public ChickenAnalyze(MinesweeperMap map, AnalyzeProvider analyze) {
        this.analyze = analyze;
        this.openFields = new ArrayList<OpenField>();
        this.unsafeReveal = new HashSet<MinesweeperField>();
        this.unsafe = new HashSet<MinesweeperField>();
    }

    public ChickenAnalyze analyze() {
        OpenFieldApproxer approxer = new OpenFieldApproxer();
        AvoidReveal50 scorer = new AvoidReveal50();
        HashSet<ProbabilityKnowledge<MinesweeperField>> fieldOfInterest = new HashSet<ProbabilityKnowledge<MinesweeperField>>();
        for (ProbabilityKnowledge<MinesweeperField> probabilityKnowledge : this.analyze.getAllKnowledge()) {
            double ofProb = probabilityKnowledge.getProbabilities()[0];
            if (ofProb == 1.0) {
                if (approxer.expectedFrom(this.analyze, (MinesweeperField)probabilityKnowledge.getField()) != 0.0) continue;
                this.addOpenField(probabilityKnowledge);
                continue;
            }
            if (ofProb != 0.0 || ((AbstractScorer)scorer).getScoreFor((MinesweeperField)probabilityKnowledge.getField(), probabilityKnowledge, null) != 0.0) continue;
            fieldOfInterest.add(probabilityKnowledge);
        }
        for (ProbabilityKnowledge probabilityKnowledge : fieldOfInterest) {
            if (MineprobHelper.getCertainValue((ProbabilityKnowledge<MinesweeperField>)probabilityKnowledge) != null) {
                if (this.existsInOpenField((MinesweeperField)probabilityKnowledge.getField())) continue;
                ++this.extraSafe;
                continue;
            }
            if (probabilityKnowledge.getMineProbability() != 0.0) continue;
            this.addUnsafe((ProbabilityKnowledge<MinesweeperField>)probabilityKnowledge);
        }
        return this;
    }

    private void addUnsafe(ProbabilityKnowledge<MinesweeperField> data) {
        this.unsafe.add((MinesweeperField)data.getField());
        this.unsafeReveal.addAll(ChickenAnalyze.getUnsafeRevealFor(data));
    }

    public static Set<MinesweeperField> getUnsafeRevealFor(ProbabilityKnowledge<MinesweeperField> data) {
        HashSet<MinesweeperField> result = new HashSet<MinesweeperField>();
        for (Map.Entry ee : data.getNeighbors().entrySet()) {
            if (((FieldGroup)ee.getKey()).size() == ((Integer)ee.getValue()).intValue()) continue;
            Collection neighbors = ((MinesweeperField)data.getField()).getNeighbors();
            neighbors.retainAll((Collection)ee.getKey());
            result.addAll(neighbors);
        }
        return result;
    }

    private void addOpenField(ProbabilityKnowledge<MinesweeperField> know) {
        if (this.existsInOpenField((MinesweeperField)know.getField())) {
            return;
        }
        OpenField of = OpenField.construct(this.analyze, know);
        this.openFields.add(of);
    }

    private boolean existsInOpenField(MinesweeperField field) {
        for (OpenField of : this.openFields) {
            if (!of.hasField(field)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return UtilZomisUtils.implode((String)", ", this.openFields) + " - extraSafe: " + this.extraSafe + " unsafe: " + this.unsafe + " unsafeReveal: " + UtilZomisUtils.implode((String)", ", this.unsafeReveal);
    }

    public int getSafeRevealedBy(AnalyzeProvider analyze, ProbabilityKnowledge<MinesweeperField> fieldData) {
        if (!this.unsafe.contains(fieldData.getField())) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        Set<MinesweeperField> myRevealOriginal = ChickenAnalyze.getUnsafeRevealFor(fieldData);
        for (MinesweeperField ff : this.unsafe) {
            if (ff == fieldData.getField()) continue;
            Set<MinesweeperField> ffReveal = ChickenAnalyze.getUnsafeRevealFor(analyze.getKnowledgeFor(ff));
            HashSet<MinesweeperField> myReveal = new HashSet<MinesweeperField>(myRevealOriginal);
            ffReveal.removeAll(myReveal);
            if (ffReveal.size() != 0) continue;
            ++i;
        }
        return i;
    }
}

