/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.ais.mirror;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.zomis.minesweeper.ais.mirror.MirrorScorer;
import net.zomis.minesweeper.ais.otherscorers.StaticScoreForWeapon;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.MinesweeperReplay;
import net.zomis.minesweeper.game.model.GameReplay;
import net.zomis.minesweeper.game.model.MapUtils;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.ScoreConfig;
import net.zomis.minesweeper.scores.ScoreConfigFactory;
import net.zomis.weapons.classic.BombWeapon;
import org.apache.commons.math3.stat.StatUtils;

public class Analyze_AI_Mirror {
    private final List<MirrorScorer> mirrors = new ArrayList<MirrorScorer>();
    private final MinesweeperPlayingPlayer player;
    private int count = 0;

    public MinesweeperPlayingPlayer getPlayer() {
        return this.player;
    }

    public Analyze_AI_Mirror(MinesweeperPlayingPlayer analyzePlayer) {
        this.player = analyzePlayer;
    }

    public Analyze_AI_Mirror addScorer(MirrorScorer mirrorScorer) {
        this.mirrors.add(mirrorScorer);
        return this;
    }

    public MinesweeperMap getMap() {
        return this.player.getMap();
    }

    public boolean moveInform(MinesweeperMove move) {
        MinesweeperMove nextmove;
        if (this.mirrors.isEmpty()) {
            throw new IllegalStateException("No MirrorScorers has been set. Call Mirror.addScorer(...)");
        }
        MinesweeperMap map = move.getMap();
        if (move.getPlayer() != this.player) {
            return false;
        }
        if (move.getField() == null) {
            return false;
        }
        if (move.getWeapon().getClass() == BombWeapon.class) {
            return false;
        }
        GameReplay replay = new GameReplay(MapUtils.getMinesString((MinesweeperMap)map), MapUtils.getClickString((MinesweeperMap)map), map.getMapFactory().standard());
        replay.rewind();
        Iterator<Object> iterator = replay.getMoves().iterator();
        while (iterator.hasNext() && !(nextmove = (MinesweeperMove)iterator.next()).equals(move)) {
            replay.nextMove();
        }
        for (MirrorScorer scorer : this.mirrors) {
            scorer.moveInform(move, replay.getMap());
        }
        ++this.count;
        return true;
    }

    public ScoreConfig getScoreConfig() {
        ScoreConfigFactory config = new ScoreConfigFactory(AnalyzeMethod.ZOMIS_ADVANCED);
        config.withScorer(new StaticScoreForWeapon("P", 10));
        for (MirrorScorer scorer : this.mirrors) {
            if (!(scorer.getPower() > 0.0)) continue;
            config = config.withScorer(scorer, scorer.getPower());
        }
        return config.build();
    }

    public double getExpectedRating() {
        if (this.mirrors.isEmpty()) {
            throw new IllegalStateException("No MirrorScorers has been set. Call Mirror.addScorer(...)");
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (MirrorScorer scorer : this.mirrors) {
            Double value = scorer.getExpectedRating(this);
            if (value == null) continue;
            list.add(value);
        }
        if (list.isEmpty()) {
            return 0.0;
        }
        return StatUtils.mean((double[])Doubles.toArray(list));
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName() + ":\n");
        for (MirrorScorer scorer : this.mirrors) {
            str.append(scorer);
            str.append("\n");
        }
        return str.toString();
    }

    public int getCount() {
        return this.count;
    }

    public void analyzeReplay(MinesweeperReplay replay) {
        replay.rewind();
        for (MinesweeperMove move : replay.getMoves()) {
            if (move.getPlayer() == this.player) {
                this.moveInform(move);
            }
            replay.nextMove();
        }
    }

    public List<MirrorScorer> getMirrors() {
        return new ArrayList<MirrorScorer>(this.mirrors);
    }
}

