/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.probability;

import net.zomis.mario.probability.BigDouble;
import net.zomis.mario.probability.Combinatory;

@Deprecated
public final class WinningProbability {
    static final int MAX_MINES = 51;
    static final int MAX_SQUARES = 256;
    static final WinningProbability instance = new WinningProbability();
    static final BigDouble[] bigDoubles = new BigDouble[257];
    static final double[][] binomialCoefficients = new double[52][257];
    BigDouble[][][] blueWinningCases = new BigDouble[27][27][257];
    double[][][] blueWinningCasesDouble = new double[27][27][257];
    BigDouble[][][] redWinningCases = new BigDouble[27][27][257];
    double[][][] redWinningCasesDouble = new double[27][27][257];
    boolean isInitialized;

    private WinningProbability() {
    }

    public static WinningProbability getInstance() {
        return instance;
    }

    public double getthis(int blue, int red, int openSeaCount) {
        boolean turn;
        if (blue >= 26) {
            return 1.0;
        }
        if (red >= 26) {
            return 0.0;
        }
        boolean bl = turn = (red + blue + openSeaCount) % 2 == 0;
        if (turn) {
            if (this.blueWinningCases[blue][red][openSeaCount] != null) {
                return this.blueWinningCasesDouble[blue][red][openSeaCount] / binomialCoefficients[51 - blue - red][openSeaCount];
            }
            return -1.0;
        }
        if (this.redWinningCases[blue][red][openSeaCount] != null) {
            return this.redWinningCasesDouble[blue][red][openSeaCount] / binomialCoefficients[51 - blue - red][openSeaCount];
        }
        return -1.0;
    }

    public void Initialize() throws Exception {
        if (!this.isInitialized) {
            this.CreateStaticArrays();
            this.Calculate();
            this.ConvertBigDoubleToDouble();
        }
        this.isInitialized = true;
    }

    private void CreateStaticArrays() throws Exception {
        for (int i = 0; i <= 256; ++i) {
            WinningProbability.bigDoubles[i] = new BigDouble(i);
            for (int j = 0; j <= 51; ++j) {
                if (j > i) continue;
                WinningProbability.binomialCoefficients[j][i] = Combinatory.BinomialCoefficientBigDouble(j, i).ToDouble();
            }
        }
    }

    private void ConvertBigDoubleToDouble() {
        for (int i = 256; i >= 0; --i) {
            for (int b = 0; b < 26; ++b) {
                for (int r = 0; r < 26; ++r) {
                    if (this.blueWinningCases[b][r][i] != null) {
                        this.blueWinningCasesDouble[b][r][i] = this.blueWinningCases[b][r][i].ToDouble();
                    }
                    if (this.redWinningCases[b][r][i] == null) continue;
                    this.redWinningCasesDouble[b][r][i] = this.redWinningCases[b][r][i].ToDouble();
                }
            }
        }
    }

    private void Calculate() throws Exception {
        this.CalculateBlue(0, 0, 256, Combinatory.BinomialCoefficientBigDouble(51, 256));
        this.CalculateRed(0, 0, 256, Combinatory.BinomialCoefficientBigDouble(51, 256));
    }

    private BigDouble CalculateRed(int blue, int red, int openSeaCount, BigDouble product) throws Exception {
        if (this.redWinningCases[blue][red][openSeaCount] != null) {
            return this.redWinningCases[blue][red][openSeaCount];
        }
        if (blue == 26) {
            this.redWinningCases[blue][red][openSeaCount] = bigDoubles[0];
            return this.redWinningCases[blue][red][openSeaCount];
        }
        if (red == 26) {
            this.redWinningCases[blue][red][openSeaCount] = product;
            return this.redWinningCases[blue][red][openSeaCount];
        }
        if (openSeaCount + blue + red - 51 <= 0) {
            this.redWinningCases[blue][red][openSeaCount] = product;
            return this.redWinningCases[blue][red][openSeaCount];
        }
        BigDouble leftTree = null;
        BigDouble rightTree = null;
        BigDouble winnningProbability = bigDoubles[51 - blue - red];
        BigDouble losingProbability = bigDoubles[openSeaCount + blue + red - 51];
        if ((red + blue + openSeaCount) % 2 == 0) {
            rightTree = this.CalculateRed(blue, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product, losingProbability), openSeaCount));
            leftTree = this.CalculateRed(blue, red + 1, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product, winnningProbability), openSeaCount));
        } else {
            rightTree = this.CalculateRed(blue, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product, losingProbability), openSeaCount));
            leftTree = this.CalculateRed(blue + 1, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product, winnningProbability), openSeaCount));
        }
        this.redWinningCases[blue][red][openSeaCount] = BigDouble.add(leftTree, rightTree);
        return this.redWinningCases[blue][red][openSeaCount];
    }

    private BigDouble CalculateBlue(int blue, int red, int openSeaCount, BigDouble product) throws Exception {
        if (this.blueWinningCases[blue][red][openSeaCount] != null) {
            return this.blueWinningCases[blue][red][openSeaCount];
        }
        if (blue == 26) {
            this.blueWinningCases[blue][red][openSeaCount] = product;
            return this.blueWinningCases[blue][red][openSeaCount];
        }
        if (red == 26) {
            this.blueWinningCases[blue][red][openSeaCount] = bigDoubles[0];
            return this.blueWinningCases[blue][red][openSeaCount];
        }
        if (51 - blue - red > openSeaCount) {
            this.blueWinningCases[blue][red][openSeaCount] = bigDoubles[0];
            return this.blueWinningCases[blue][red][openSeaCount];
        }
        BigDouble leftTree = null;
        BigDouble rightTree = null;
        BigDouble winnningProbability = bigDoubles[51 - blue - red];
        BigDouble losingProbability = bigDoubles[openSeaCount + blue + red - 51];
        if ((red + blue + openSeaCount) % 2 == 0) {
            rightTree = this.CalculateBlue(blue, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product, losingProbability), openSeaCount));
            leftTree = this.CalculateBlue(blue + 1, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product, winnningProbability), openSeaCount));
        } else {
            rightTree = this.CalculateBlue(blue, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product, losingProbability), openSeaCount));
            leftTree = this.CalculateBlue(blue, red + 1, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product, winnningProbability), openSeaCount));
        }
        this.blueWinningCases[blue][red][openSeaCount] = BigDouble.add(leftTree, rightTree);
        return this.blueWinningCases[blue][red][openSeaCount];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(0x400000);
        for (int i = 256; i >= 0; --i) {
            stringBuilder.append("[" + i + "]\n");
            for (int b = 0; b <= 26; ++b) {
                for (int r = 0; r <= 26; ++r) {
                    if (i + b + r > 256 || i + b + r < 51) continue;
                    stringBuilder.append("[");
                    stringBuilder.append(b);
                    stringBuilder.append(",");
                    stringBuilder.append(r);
                    stringBuilder.append("] = ");
                    stringBuilder.append(this.getthis(b, r, i));
                    stringBuilder.append("\n");
                }
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append(stringBuilder.capacity() + "\n");
        return stringBuilder.toString();
    }
}

