/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mario.classes;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.zomis.mario.classes.Board;
import net.zomis.mario.classes.Click;
import net.zomis.mario.classes.Enums;
import net.zomis.mario.classes.Player;

public class Bot
extends Player {
    private Board board;
    private static TimeLimiter limiter = new SimpleTimeLimiter();

    public Board getBoard() {
        return this.board;
    }

    public void javaGarbage() {
        if (this.board != null) {
            this.board.javaGarbage();
        }
    }

    public Bot(Enums.PlayerColor player, Enums.Difficult difficult) {
        this.playerColor = player;
        this.difficulty = difficult;
    }

    @Override
    public List<Click> move(char[][] logicBoard) {
        try {
            return (List)limiter.callWithTimeout((Callable)new MarioTimeout(this, logicBoard), 30L, TimeUnit.SECONDS, true);
        }
        catch (Exception e) {
            this.javaGarbage();
            return null;
        }
    }

    private List<Click> realmove(char[][] logicBoard) {
        ArrayList<Click> moves;
        block16: {
            boolean[][] maxExpectedValuePoints;
            int j;
            int i;
            block18: {
                block17: {
                    block15: {
                        this.javaGarbage();
                        if (this.difficulty == null) {
                            throw new IllegalStateException("Bot difficulty is null.");
                        }
                        moves = new ArrayList<Click>();
                        this.initBoard(logicBoard);
                        this.board.Solve();
                        if (this.difficulty != Enums.Difficult.VERY_EASY) {
                            boolean[][] obviousMines = this.board.obviousMines;
                            for (i = 0; i < this.board.getDIMV(); ++i) {
                                for (j = 0; j < this.board.getDIMH(); ++j) {
                                    if (!obviousMines[i][j]) continue;
                                    moves.add(new Click(i, j, Enums.ClickType.OBVIOUS_MINE));
                                    return moves;
                                }
                            }
                        }
                        if (this.difficulty.ordinal() >= Enums.Difficult.MEDIUM.ordinal()) {
                            if (this.board.groups != null && this.board.groups.size() == 0 && this.board.maxExpectedValue != null && this.board.maxExpectedValue < 0.0) {
                                if (this.difficulty.equals((Object)Enums.Difficult.VERY_HARD_NO_SIMULATE)) {
                                    return null;
                                }
                                Board.Simulate(this.board, 6);
                            }
                            boolean[][] notSoObviousMines = this.board.notSoObviousMines;
                            for (i = 0; i < this.board.getDIMH(); ++i) {
                                for (j = 0; j < this.board.getDIMV(); ++j) {
                                    if (!notSoObviousMines[i][j]) continue;
                                    moves.add(new Click(i, j, Enums.ClickType.NOT_SO_OBVIOUS_MINE));
                                    return moves;
                                }
                            }
                        }
                        if (this.difficulty != Enums.Difficult.EASY && this.difficulty != Enums.Difficult.VERY_EASY) break block15;
                        moves.add(null);
                        break block16;
                    }
                    if (this.difficulty != Enums.Difficult.MEDIUM) break block17;
                    maxExpectedValuePoints = this.board.MaxFirstExpectedValuePoints();
                    for (i = 0; i < this.board.getDIMV(); ++i) {
                        for (j = 0; j < this.board.getDIMH(); ++j) {
                            if (!maxExpectedValuePoints[i][j]) continue;
                            moves.add(new Click(i, j, Enums.ClickType.MAX_FIRST_EXPECTED_VALUE));
                        }
                    }
                    break block16;
                }
                if (this.difficulty != Enums.Difficult.HARD) break block18;
                maxExpectedValuePoints = this.board.MaxExpectedValuePoints();
                for (i = 0; i < this.board.getDIMV(); ++i) {
                    for (j = 0; j < this.board.getDIMH(); ++j) {
                        if (!maxExpectedValuePoints[i][j]) continue;
                        moves.add(new Click(i, j, Enums.ClickType.MAX_EXPECTED_VALUE));
                    }
                }
                break block16;
            }
            if (this.difficulty.ordinal() < Enums.Difficult.VERY_HARD.ordinal()) break block16;
            maxExpectedValuePoints = this.board.MaxExpectedValuePoints();
            for (i = 0; i < this.board.getDIMV(); ++i) {
                for (j = 0; j < this.board.getDIMH(); ++j) {
                    if (!maxExpectedValuePoints[i][j]) continue;
                    moves.add(new Click(i, j, Enums.ClickType.MAX_EXPECTED_VALUE));
                }
            }
        }
        return moves;
    }

    private void initBoard(char[][] logicBoard) {
        this.board = this.difficulty.ordinal() < Enums.Difficult.HARD.ordinal() ? new Board(logicBoard, 1, 1) : new Board(logicBoard, 1, 2);
        this.board.OnEventLog = null;
    }

    private static class MarioTimeout
    implements Callable<List<Click>> {
        private Bot bot;
        private char[][] board;

        public MarioTimeout(Bot bot, char[][] logicBoard) {
            this.bot = bot;
            this.board = logicBoard;
        }

        @Override
        public List<Click> call() throws Exception {
            return this.bot.realmove(this.board);
        }
    }
}

